/*
 * Legislate API
 * The Legislate API is organized around REST. Our API has predictable resource-oriented URLs, accepts form-encoded request bodies, returns JSON-encoded responses, and uses standard HTTP response codes, authentication, and verbs.
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.legislate.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.legislate.model.CreateCollaboratorIdentityFieldV1DTO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * CollaboratorFieldsRequestDTO
 */


public class CollaboratorFieldsRequestDTO {
  @SerializedName("email")
  private String email = null;

  @SerializedName("identityFields")
  private List<CreateCollaboratorIdentityFieldV1DTO> identityFields = new ArrayList<CreateCollaboratorIdentityFieldV1DTO>();

  @SerializedName("inviterId")
  private Long inviterId = null;

  /**
   * Gets or Sets role
   */
  @JsonAdapter(RoleEnum.Adapter.class)
  public enum RoleEnum {
    COLLABORATOR("collaborator"),
    PARTY("party"),
    PARTY_WITH_SIGNATORY("party_with_signatory"),
    SIGNATORY("signatory"),
    SUPP_SIG("supp_sig"),
    WITNESS("witness");

    private String value;

    RoleEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static RoleEnum fromValue(String input) {
      for (RoleEnum b : RoleEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return null;
    }
    public static class Adapter extends TypeAdapter<RoleEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final RoleEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public RoleEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return RoleEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("role")
  private List<RoleEnum> role = new ArrayList<RoleEnum>();

  /**
   * The side of contract collaborator.
   */
  @JsonAdapter(SideEnum.Adapter.class)
  public enum SideEnum {
    BOTH("both"),
    FIRST("first"),
    SECOND("second");

    private String value;

    SideEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static SideEnum fromValue(String input) {
      for (SideEnum b : SideEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return null;
    }
    public static class Adapter extends TypeAdapter<SideEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final SideEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public SideEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return SideEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("side")
  private SideEnum side = null;

  @SerializedName("signatoryId")
  private Long signatoryId = null;

  @SerializedName("userId")
  private Long userId = null;

  public CollaboratorFieldsRequestDTO email(String email) {
    this.email = email;
    return this;
  }

   /**
   * The unique email of the contract collaborator. Deprecated: Will be removed in v2.0.0
   * @return email
  **/
  @Schema(description = "The unique email of the contract collaborator. Deprecated: Will be removed in v2.0.0")
  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public CollaboratorFieldsRequestDTO identityFields(List<CreateCollaboratorIdentityFieldV1DTO> identityFields) {
    this.identityFields = identityFields;
    return this;
  }

  public CollaboratorFieldsRequestDTO addIdentityFieldsItem(CreateCollaboratorIdentityFieldV1DTO identityFieldsItem) {
    this.identityFields.add(identityFieldsItem);
    return this;
  }

   /**
   * The identity fields of the contract collaborator.
   * @return identityFields
  **/
  @Schema(required = true, description = "The identity fields of the contract collaborator.")
  public List<CreateCollaboratorIdentityFieldV1DTO> getIdentityFields() {
    return identityFields;
  }

  public void setIdentityFields(List<CreateCollaboratorIdentityFieldV1DTO> identityFields) {
    this.identityFields = identityFields;
  }

  public CollaboratorFieldsRequestDTO inviterId(Long inviterId) {
    this.inviterId = inviterId;
    return this;
  }

   /**
   * The unique Id of the user who is inviting the collaborator to the contract.
   * @return inviterId
  **/
  @Schema(required = true, description = "The unique Id of the user who is inviting the collaborator to the contract.")
  public Long getInviterId() {
    return inviterId;
  }

  public void setInviterId(Long inviterId) {
    this.inviterId = inviterId;
  }

  public CollaboratorFieldsRequestDTO role(List<RoleEnum> role) {
    this.role = role;
    return this;
  }

  public CollaboratorFieldsRequestDTO addRoleItem(RoleEnum roleItem) {
    this.role.add(roleItem);
    return this;
  }

   /**
   * The role of contract collaborator.
   * @return role
  **/
  @Schema(required = true, description = "The role of contract collaborator.")
  public List<RoleEnum> getRole() {
    return role;
  }

  public void setRole(List<RoleEnum> role) {
    this.role = role;
  }

  public CollaboratorFieldsRequestDTO side(SideEnum side) {
    this.side = side;
    return this;
  }

   /**
   * The side of contract collaborator.
   * @return side
  **/
  @Schema(required = true, description = "The side of contract collaborator.")
  public SideEnum getSide() {
    return side;
  }

  public void setSide(SideEnum side) {
    this.side = side;
  }

  public CollaboratorFieldsRequestDTO signatoryId(Long signatoryId) {
    this.signatoryId = signatoryId;
    return this;
  }

   /**
   * The unique Id of the contract signatory who is going to sign the contract on behalf of the party / company.
   * @return signatoryId
  **/
  @Schema(description = "The unique Id of the contract signatory who is going to sign the contract on behalf of the party / company.")
  public Long getSignatoryId() {
    return signatoryId;
  }

  public void setSignatoryId(Long signatoryId) {
    this.signatoryId = signatoryId;
  }

  public CollaboratorFieldsRequestDTO userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * The unique Id of the contract collaborator you are adding to the contract.
   * @return userId
  **/
  @Schema(required = true, description = "The unique Id of the contract collaborator you are adding to the contract.")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CollaboratorFieldsRequestDTO collaboratorFieldsRequestDTO = (CollaboratorFieldsRequestDTO) o;
    return Objects.equals(this.email, collaboratorFieldsRequestDTO.email) &&
        Objects.equals(this.identityFields, collaboratorFieldsRequestDTO.identityFields) &&
        Objects.equals(this.inviterId, collaboratorFieldsRequestDTO.inviterId) &&
        Objects.equals(this.role, collaboratorFieldsRequestDTO.role) &&
        Objects.equals(this.side, collaboratorFieldsRequestDTO.side) &&
        Objects.equals(this.signatoryId, collaboratorFieldsRequestDTO.signatoryId) &&
        Objects.equals(this.userId, collaboratorFieldsRequestDTO.userId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(email, identityFields, inviterId, role, side, signatoryId, userId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CollaboratorFieldsRequestDTO {\n");
    
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    identityFields: ").append(toIndentedString(identityFields)).append("\n");
    sb.append("    inviterId: ").append(toIndentedString(inviterId)).append("\n");
    sb.append("    role: ").append(toIndentedString(role)).append("\n");
    sb.append("    side: ").append(toIndentedString(side)).append("\n");
    sb.append("    signatoryId: ").append(toIndentedString(signatoryId)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
