/*
 * Decompiled with CFR 0.152.
 */
package tech.lastbox.jwt;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.HashSet;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.lastbox.jwt.DateUtil;
import tech.lastbox.jwt.Token;
import tech.lastbox.jwt.TokenEntity;

class TokenUtil {
    private static final Logger logger = LoggerFactory.getLogger(TokenUtil.class);

    TokenUtil() {
    }

    public static Token convertDecodedJwtToToken(DecodedJWT decodedJWT) {
        return new Token(decodedJWT.getToken(), decodedJWT.getSubject(), DateUtil.instantToLocalDateTime(decodedJWT.getIssuedAtAsInstant()), DateUtil.instantToLocalDateTime(decodedJWT.getExpiresAtAsInstant()), decodedJWT.getIssuer(), decodedJWT.getClaim("scope").asList(String.class), false);
    }

    public static Token convertEntityToToken(TokenEntity tokenEntity) {
        return new Token(tokenEntity.getToken(), tokenEntity.getSubject(), DateUtil.instantToLocalDateTime(tokenEntity.getIssuedAt()), DateUtil.instantToLocalDateTime(tokenEntity.getExpiresIn()), tokenEntity.getIssuer(), tokenEntity.getScope(), tokenEntity.isRevoked());
    }

    public static Optional<Token> validateDecodedToken(Algorithm algorithm, HashSet<String> trustedIssuers, String token) {
        try {
            String issuer = JWT.decode((String)token).getIssuer();
            if (trustedIssuers.contains(issuer.toLowerCase())) {
                DecodedJWT decodedJWT = JWT.require((Algorithm)algorithm).withIssuer(issuer).build().verify(token);
                return Optional.of(TokenUtil.convertDecodedJwtToToken(decodedJWT));
            }
            logger.error("Token validation failed: Issuer '{}' is not trusted. Token: {}", (Object)issuer, (Object)token);
            return Optional.empty();
        }
        catch (Exception e) {
            logger.error("Token validation failed for token '{}'. Exception: {}. Possible causes: 1. Invalid signature or 2. Issuer mismatch. Error details: {}", new Object[]{token, e.getLocalizedMessage(), e.getMessage(), e});
            return Optional.empty();
        }
    }
}

