/*
 * Decompiled with CFR 0.152.
 */
package tech.lastbox.jwt;

import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.time.Instant;
import java.util.List;

@Entity
@Table(name="jwt_tokens")
public class TokenEntity {
    @Id
    private String token;
    private Instant issuedAt;
    private Instant expiresIn;
    private String subject;
    private String issuer;
    @ElementCollection
    private List<String> scope;
    private boolean isRevoked;

    public TokenEntity() {
    }

    public TokenEntity(String token, Instant issuedAt, Instant expiresIn, String subject, String issuer, List<String> scope) {
        this.token = token;
        this.issuedAt = issuedAt;
        this.expiresIn = expiresIn;
        this.subject = subject;
        this.issuer = issuer;
        this.scope = scope;
    }

    public String getToken() {
        return this.token;
    }

    public Instant getIssuedAt() {
        return this.issuedAt;
    }

    public Instant getExpiresIn() {
        return this.expiresIn;
    }

    public String getSubject() {
        return this.subject;
    }

    public boolean isRevoked() {
        return this.isRevoked;
    }

    public void setRevoked(boolean isRevoked) {
        this.isRevoked = isRevoked;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public List<String> getScope() {
        return this.scope;
    }

    public boolean isExpired() {
        return this.expiresIn == null || this.expiresIn.isBefore(Instant.now());
    }

    public boolean isValid() {
        return !this.isExpired() && !this.isRevoked;
    }
}

