/*
 * Decompiled with CFR 0.152.
 */
package tech.lastbox.jwt;

import java.util.HashSet;
import java.util.List;
import tech.lastbox.jwt.AlgorithmException;
import tech.lastbox.jwt.ExpirationTimeUnit;
import tech.lastbox.jwt.JwtAlgorithm;
import tech.lastbox.jwt.TokenStore;

public class JwtConfig {
    private final JwtAlgorithm jwtAlgorithm;
    private final String secretKey;
    private final HashSet<String> trustedIssuers;
    private final long expirationAmount;
    private final ExpirationTimeUnit expirationTimeUnit;
    private final TokenStore tokenStore;
    private final List<String> DEFAULT_ISSUERS = List.of("google", "github", "facebook", "microsoft", "twitter", "linkedin", "spotify");

    public JwtConfig(JwtAlgorithm jwtAlgorithm, String secretKey, String issuer, long expirationAmount, ExpirationTimeUnit expirationTimeUnit, TokenStore tokenStore) {
        this.validateAlgorithmAndKey(jwtAlgorithm, secretKey);
        this.jwtAlgorithm = jwtAlgorithm;
        this.secretKey = secretKey;
        this.trustedIssuers = this.generateTrustedIssuers(issuer);
        this.expirationAmount = expirationAmount;
        this.expirationTimeUnit = expirationTimeUnit;
        this.tokenStore = tokenStore;
    }

    public JwtConfig(JwtAlgorithm jwtAlgorithm, String secretKey, String issuer, long expirationAmount, ExpirationTimeUnit expirationTimeUnit) {
        this.validateAlgorithmAndKey(jwtAlgorithm, secretKey);
        this.jwtAlgorithm = jwtAlgorithm;
        this.secretKey = secretKey;
        this.trustedIssuers = this.generateTrustedIssuers(issuer);
        this.expirationAmount = expirationAmount;
        this.expirationTimeUnit = expirationTimeUnit;
        this.tokenStore = null;
    }

    public JwtConfig(JwtAlgorithm jwtAlgorithm, String secretKey, List<String> issuers, long expirationAmount, ExpirationTimeUnit expirationTimeUnit, TokenStore tokenStore) {
        this.validateAlgorithmAndKey(jwtAlgorithm, secretKey);
        this.jwtAlgorithm = jwtAlgorithm;
        this.secretKey = secretKey;
        this.trustedIssuers = this.generateTrustedIssuers(issuers);
        this.expirationAmount = expirationAmount;
        this.expirationTimeUnit = expirationTimeUnit;
        this.tokenStore = tokenStore;
    }

    public JwtConfig(JwtAlgorithm jwtAlgorithm, String secretKey, List<String> issuers, long expirationAmount, ExpirationTimeUnit expirationTimeUnit) {
        this.validateAlgorithmAndKey(jwtAlgorithm, secretKey);
        this.jwtAlgorithm = jwtAlgorithm;
        this.secretKey = secretKey;
        this.trustedIssuers = this.generateTrustedIssuers(issuers);
        this.expirationAmount = expirationAmount;
        this.expirationTimeUnit = expirationTimeUnit;
        this.tokenStore = null;
    }

    private void validateAlgorithmAndKey(JwtAlgorithm jwtAlgorithm, String secretKey) {
        if (jwtAlgorithm == null || secretKey == null || secretKey.isEmpty()) {
            throw new AlgorithmException("JWT Algorithm and secretKey must not be null or empty");
        }
    }

    private HashSet<String> generateTrustedIssuers(List<String> issuers) {
        HashSet<String> trustedIssuers = new HashSet<String>(this.DEFAULT_ISSUERS);
        trustedIssuers.addAll(issuers);
        return trustedIssuers;
    }

    private HashSet<String> generateTrustedIssuers(String issuer) {
        HashSet<String> trustedIssuers = new HashSet<String>(this.DEFAULT_ISSUERS);
        trustedIssuers.add(issuer);
        return trustedIssuers;
    }

    public JwtAlgorithm getJwtAlgorithm() {
        return this.jwtAlgorithm;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public HashSet<String> getTrustedIssuers() {
        return this.trustedIssuers;
    }

    public long getExpirationAmount() {
        return this.expirationAmount;
    }

    public ExpirationTimeUnit getExpirationTimeUnit() {
        return this.expirationTimeUnit;
    }

    public TokenStore getTokenStore() {
        return this.tokenStore;
    }
}

