/*
 * Decompiled with CFR 0.152.
 */
package tech.lastbox.lastshield.security.core;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Component;
import tech.lastbox.lastshield.security.core.AdvancedFilterChecker;
import tech.lastbox.lastshield.security.core.annotations.UserHandler;

@Component
public class SecurityUtil {
    private final Logger logger = LoggerFactory.getLogger(SecurityUtil.class);

    public Class<?> getUserRepositoryClass() {
        if (AdvancedFilterChecker.isAdvancedFiltered()) {
            ClassLoader classLoader;
            for (ClassLoader cl = classLoader = Thread.currentThread().getContextClassLoader(); cl != null; cl = cl.getParent()) {
                for (Class<?> cls : this.getAllClassesFromClassLoader(cl)) {
                    if (!cls.isAnnotationPresent(UserHandler.class)) continue;
                    try {
                        return cls;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error instantiating UserService", e);
                    }
                }
            }
            throw new RuntimeException("No UserHandler found");
        }
        return null;
    }

    public List<GrantedAuthority> getUserAuthorities(Object user) {
        return this.convertRolesToAuthorities(this.getUserRoles(user));
    }

    public Object findUserByUsername(Object userService, String username) {
        try {
            Method method = userService.getClass().getDeclaredMethod("findUserByUsername", String.class);
            method.setAccessible(true);
            return method.invoke(userService, username);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("The method 'getUserByUsername' was not found in the provided class.", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Error invoking 'getUserByUsername' on the provided class.", e);
        }
    }

    private List<Class<?>> getAllClassesFromClassLoader(ClassLoader classLoader) {
        ArrayList classes = new ArrayList();
        try {
            Enumeration<URL> resources = classLoader.getResources("");
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                if (!resource.getProtocol().equals("file")) continue;
                classes.addAll(this.findClassesInDirectory(new File(resource.toURI()), ""));
            }
        }
        catch (Exception e) {
            this.logger.error("Error: {}", (Object)e, (Object)e);
        }
        return classes;
    }

    private List<Class<?>> findClassesInDirectory(File directory, String packageName) {
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    classes.addAll(this.findClassesInDirectory(file, packageName + file.getName() + "."));
                    continue;
                }
                if (!file.getName().endsWith(".class")) continue;
                String className = packageName + file.getName().substring(0, file.getName().length() - 6);
                try {
                    classes.add(Class.forName(className));
                }
                catch (ClassNotFoundException e) {
                    this.logger.error("Error: {}", (Object)e, (Object)e);
                }
            }
        }
        return classes;
    }

    private <T> T getFieldValue(Object object, String fieldName) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            Object value = field.get(object);
            return (T)field.get(object);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Error accessing the field '" + fieldName + "' in " + object.getClass().getName(), e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("The field '" + fieldName + "' is not of the expected type.", e);
        }
    }

    private List<String> getUserRoles(Object user) {
        try {
            return (List)this.getFieldValue(user, "roles");
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof NoSuchFieldException) {
                try {
                    String singleRole = (String)this.getFieldValue(user, "role");
                    return List.of(singleRole);
                }
                catch (RuntimeException ex) {
                    throw new RuntimeException("Failed to retrieve roles or role field", ex);
                }
            }
            throw e;
        }
    }

    private List<GrantedAuthority> convertRolesToAuthorities(List<String> roles) {
        return roles.stream().map(role -> new SimpleGrantedAuthority(this.treatRole((String)role))).collect(Collectors.toList());
    }

    private String treatRole(String role) {
        if (role.startsWith("ROLE_")) {
            return role;
        }
        return String.format("ROLE_%s", role);
    }
}

