/*
 * Decompiled with CFR 0.152.
 */
package tech.lastbox.lastshield.security.core;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;
import tech.lastbox.jwt.JwtService;
import tech.lastbox.jwt.Token;
import tech.lastbox.jwt.TokenValidation;
import tech.lastbox.lastshield.security.core.AdvancedFilterChecker;
import tech.lastbox.lastshield.security.core.SecurityUtil;

@Component
public class SecurityFilter
extends OncePerRequestFilter {
    private final JwtService jwtService;
    private Object userRepository;
    private final ApplicationContext applicationContext;
    private final Logger logger = LoggerFactory.getLogger(SecurityFilter.class);
    private final SecurityUtil securityUtil;

    public SecurityFilter(JwtService jwtService, ApplicationContext applicationContext, SecurityUtil securityUtil) {
        this.jwtService = jwtService;
        this.applicationContext = applicationContext;
        this.securityUtil = securityUtil;
    }

    public void setUserRepository(Class<?> userRepositoryClass) {
        this.userRepository = this.applicationContext.getBean(userRepositoryClass);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            if (AdvancedFilterChecker.isAdvancedFiltered()) {
                String authorization = this.recoverToken(request);
                if (authorization == null || authorization.isEmpty()) {
                    response.sendError(401, "Token is missing");
                    return;
                }
                TokenValidation tokenValidation = this.jwtService.validateToken(authorization);
                Optional tokenOptional = tokenValidation.tokenOptional();
                if (tokenOptional.isPresent() && tokenValidation.isValid()) {
                    Token token = (Token)tokenOptional.get();
                    Optional userEntityOptional = (Optional)this.securityUtil.findUserByUsername(this.userRepository, token.subject());
                    if (userEntityOptional.isEmpty()) {
                        response.sendError(403, "User not found");
                        return;
                    }
                    Object userEntity = userEntityOptional.get();
                    List<GrantedAuthority> authorities = this.securityUtil.getUserAuthorities(userEntity);
                    System.out.println(authorities);
                    UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken(userEntity, null, authorities);
                    SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
                } else {
                    response.sendError(403, "Invalid token");
                }
            }
        }
        catch (RuntimeException e) {
            this.logger.error("Exception in SecurityFilter: {}", (Object)e.getMessage(), (Object)e);
            response.sendError(500, "Unexpected error");
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected boolean shouldNotFilter(HttpServletRequest request) {
        String path = request.getServletPath();
        if (AdvancedFilterChecker.isAdvancedFiltered()) {
            return AdvancedFilterChecker.isInShoudNotFilterList(path);
        }
        return true;
    }

    private String recoverToken(HttpServletRequest request) {
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null) {
            return null;
        }
        return authHeader.replace("Bearer ", "");
    }
}

