/*
 * Decompiled with CFR 0.152.
 */
package tech.lastbox.lastshield.security.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import tech.lastbox.lastshield.security.core.http.HttpMethod;

public class RouteAuthority {
    private final String path;
    private final String[] roles;
    private final List<HttpMethod> httpMethods = new ArrayList<HttpMethod>();

    public RouteAuthority(String path) {
        this.path = path;
        this.roles = null;
    }

    public RouteAuthority(String path, String role) {
        this.path = path;
        this.roles = new String[]{role};
    }

    public RouteAuthority(String path, String role, HttpMethod ... httpMethods) {
        this.path = path;
        this.roles = new String[]{role};
        this.httpMethods.addAll(Arrays.asList(httpMethods));
    }

    public RouteAuthority(String path, List<String> roles) {
        this.path = path;
        this.roles = roles.toArray(roles.toArray(new String[0]));
    }

    public RouteAuthority(String path, HttpMethod ... httpMethods) {
        this.path = path;
        this.roles = null;
        this.httpMethods.addAll(Arrays.asList(httpMethods));
    }

    public String getPath() {
        return this.path;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public List<HttpMethod> getHttpMethods() {
        return this.httpMethods;
    }

    public String toString() {
        return "RouteAuthority{path='" + this.path + "', roles=" + Arrays.toString(this.roles) + ", httpMethods=" + String.valueOf(this.httpMethods) + "}";
    }
}

