/*
 * Decompiled with CFR 0.152.
 */
package tech.lastbox.lastshield.security.core;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.CorsConfigurer;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
public class CorsConfig {
    private List<String> allowedOrigins;
    private List<String> allowedMethods;
    private List<String> allowedHeaders;
    private Boolean allowCredentials;
    private final Logger logger = LoggerFactory.getLogger(CorsConfig.class);

    @Bean
    public Customizer<CorsConfigurer<HttpSecurity>> configure() {
        return cors -> this.corsConfigurationSource();
    }

    private void corsConfigurationSource() {
        this.logger.info("\u2705 CORS Configuration Initialized");
        CorsConfiguration configuration = new CorsConfiguration();
        if (this.allowedOrigins == null) {
            configuration.setAllowedOrigins(List.of("*"));
        }
        if (this.allowedMethods == null) {
            configuration.setAllowedMethods(List.of("GET", "POST", "PUT", "DELETE", "OPTIONS"));
        }
        if (this.allowedHeaders == null) {
            configuration.setAllowedHeaders(List.of("*"));
        }
        if (this.allowCredentials == null) {
            configuration.setAllowCredentials(Boolean.valueOf(true));
        }
        configuration.setAllowedOrigins(this.allowedOrigins);
        configuration.setAllowedMethods(this.allowedMethods);
        configuration.setAllowCredentials(this.allowCredentials);
        configuration.addAllowedHeader("*");
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
    }

    public void setAllowedOrigins(String origin) {
        this.allowedOrigins.add(origin);
    }

    public void setAllowedOrigins(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public void setAllowedMethods(String method) {
        this.allowedMethods.add(method);
    }

    public void setAllowedMethods(List<String> allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public void setAllowedHeaders(String header) {
        this.allowedHeaders.add(header);
    }

    public void setAllowedHeaders(List<String> allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
    }

    public void setAllowCredentials(Boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
    }
}

