/*
 * Decompiled with CFR 0.152.
 */
package tech.lastbox.lastshield.security.core;

import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import tech.lastbox.lastshield.security.core.AdvancedFilterChecker;
import tech.lastbox.lastshield.security.core.CorsConfig;
import tech.lastbox.lastshield.security.core.RouteAuthority;
import tech.lastbox.lastshield.security.core.SecurityFilter;
import tech.lastbox.lastshield.security.core.SecurityUtil;

@Configuration
@ComponentScan
@EnableWebSecurity
public class CoreSecurityConfig {
    private boolean isCalled = false;
    private boolean csrfProtection = true;
    private final CorsConfig corsConfig;
    private final SecurityUtil securityUtil;
    private final SecurityFilter securityFilter;
    private final List<RouteAuthority> authorities = new ArrayList<RouteAuthority>();
    private final Logger logger = LoggerFactory.getLogger(CoreSecurityConfig.class);

    public CoreSecurityConfig(CorsConfig corsConfig, SecurityUtil securityUtil, SecurityFilter securityFilter) {
        this.corsConfig = corsConfig;
        this.securityUtil = securityUtil;
        this.securityFilter = securityFilter;
    }

    void setAdvancedFilter() {
        AdvancedFilterChecker.setAdvancedFiltered(true);
    }

    @Bean
    public SecurityFilterChain defaultSecurityFilterChain(HttpSecurity http) throws Exception {
        if (!this.isCalled) {
            throw new RuntimeException("Build() method is not called");
        }
        try {
            return (SecurityFilterChain)http.cors(this.corsConfig.configure()).csrf(this::configureCsrfProtection).authorizeHttpRequests(this.configureAuthorities()).exceptionHandling(exceptionHandling -> exceptionHandling.authenticationEntryPoint((request, response, authException) -> this.handleUnauthorized(response)).accessDeniedHandler((request, response, accessDeniedException) -> this.handleAccessDenied(response))).addFilterBefore((Filter)this.securityFilter, UsernamePasswordAuthenticationFilter.class).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Customizer<AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry> configureAuthorities() {
        return authorize -> {
            this.authorities.forEach(authority -> this.configureAuthority((AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry)authorize, (RouteAuthority)authority));
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.anyRequest()).authenticated();
        };
    }

    private void configureAuthority(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorize, RouteAuthority authority) {
        if (authority.getHttpMethods().isEmpty()) {
            this.configurePathOnly(authorize, authority);
        } else {
            this.configurePathWithMethods(authorize, authority);
        }
    }

    private void configurePathOnly(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorize, RouteAuthority authority) {
        AuthorizeHttpRequestsConfigurer.AuthorizedUrl matcher = (AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(new String[]{authority.getPath()});
        this.applyAuthorization(matcher, authority.getRoles());
    }

    private void configurePathWithMethods(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorize, RouteAuthority authority) {
        authority.getHttpMethods().forEach(method -> {
            AuthorizeHttpRequestsConfigurer.AuthorizedUrl matcher = (AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(new String[]{method.name(), authority.getPath()});
            this.applyAuthorization(matcher, authority.getRoles());
        });
    }

    private void applyAuthorization(AuthorizeHttpRequestsConfigurer.AuthorizedUrl authorizedUrl, String[] roles) {
        if (roles == null) {
            authorizedUrl.permitAll();
        } else {
            authorizedUrl.hasAnyRole(roles);
        }
    }

    private void configureCsrfProtection(CsrfConfigurer<HttpSecurity> csrf) {
        if (!this.csrfProtection) {
            csrf.disable();
        }
    }

    public void addAuthority(RouteAuthority routeAuthority) {
        this.authorities.add(routeAuthority);
        this.logger.debug("Added authority: {}", (Object)routeAuthority);
        if (routeAuthority.getRoles() == null) {
            AdvancedFilterChecker.addShoudNotFilterPath(routeAuthority.getPath());
            this.logger.debug("Added path to not filter: {}", (Object)routeAuthority.getPath());
        }
        if (!AdvancedFilterChecker.isAdvancedFiltered()) {
            this.setAdvancedFilter();
            this.securityFilter.setUserRepository(this.securityUtil.getUserRepositoryClass());
            this.logger.debug("Advanced filter set up with repository: {}", (Object)this.securityUtil.getUserRepositoryClass().getName());
        }
    }

    public void setCsrfProtection(boolean csrfProtection) {
        this.csrfProtection = csrfProtection;
    }

    public void isCalled() {
        this.isCalled = true;
    }

    private void writeErrorResponse(HttpServletResponse response, int status, String message) throws IOException {
        response.setStatus(status);
        response.setContentType("application/json");
        String jsonResponse = String.format("{\"message\": \"%s\", \"status\": %d, \"timestamp\": \"%s\"}", message, status, LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        response.getWriter().write(jsonResponse);
    }

    private void handleUnauthorized(HttpServletResponse response) throws IOException {
        this.writeErrorResponse(response, 401, "Unauthorized");
    }

    private void handleAccessDenied(HttpServletResponse response) throws IOException {
        this.writeErrorResponse(response, 403, "Access Denied");
    }
}

