/*
 * Decompiled with CFR 0.152.
 */
package tech.lastbox.lastshield.security;

import java.util.HashSet;
import java.util.List;
import org.springframework.stereotype.Component;
import tech.lastbox.lastshield.security.core.CoreSecurityConfig;
import tech.lastbox.lastshield.security.core.CorsConfig;
import tech.lastbox.lastshield.security.core.RouteAuthority;
import tech.lastbox.lastshield.security.core.http.HttpMethod;

@Component
public class SecurityConfig {
    private final CorsConfig corsConfig;
    private final CoreSecurityConfig coreSecurityConfig;

    public SecurityConfig(CoreSecurityConfig coreSecurityConfig, CorsConfig corsConfig) {
        this.coreSecurityConfig = coreSecurityConfig;
        this.corsConfig = corsConfig;
    }

    public SecurityConfig corsAllowedOrigins(String allowedOrigin) {
        this.corsConfig.setAllowedOrigins(allowedOrigin);
        return this;
    }

    public SecurityConfig corsAllowedOrigins(List<String> allowedOrigins) {
        this.corsConfig.setAllowedOrigins(allowedOrigins);
        return this;
    }

    public SecurityConfig corsAllowMethods(String allowedMethod) {
        this.corsConfig.setAllowedMethods(allowedMethod);
        return this;
    }

    public SecurityConfig corsAllowedMethods(List<String> allowedMethods) {
        this.corsConfig.setAllowedMethods(allowedMethods);
        return this;
    }

    public SecurityConfig corsAllowedHeaders(String allowedHeader) {
        this.corsConfig.setAllowedHeaders(allowedHeader);
        return this;
    }

    public SecurityConfig corsAllowedHeaders(List<String> allowedHeaders) {
        this.corsConfig.setAllowedHeaders(allowedHeaders);
        return this;
    }

    public SecurityConfig corsAllowCredentials(boolean allowCredentials) {
        this.corsConfig.setAllowCredentials(Boolean.valueOf(allowCredentials));
        return this;
    }

    public SecurityConfig setCsrfProtection(boolean csrfProtection) {
        this.coreSecurityConfig.setCsrfProtection(csrfProtection);
        return this;
    }

    public SecurityConfig addRouteAuthority(String path) {
        this.coreSecurityConfig.addAuthority(new RouteAuthority(path));
        return this;
    }

    public SecurityConfig addRouteAuthority(String path, HttpMethod httpMethod) {
        this.coreSecurityConfig.addAuthority(new RouteAuthority(path, new HttpMethod[]{httpMethod}));
        return this;
    }

    public SecurityConfig addRouteAuthority(String path, HashSet<HttpMethod> httpMethods) {
        httpMethods.forEach(httpMethod -> this.coreSecurityConfig.addAuthority(new RouteAuthority(path, new HttpMethod[]{httpMethod})));
        return this;
    }

    public SecurityConfig addRouteAuthority(String path, String role) {
        this.coreSecurityConfig.addAuthority(new RouteAuthority(path, role));
        return this;
    }

    public SecurityConfig addRouteAuthority(String path, List<String> roles) {
        this.coreSecurityConfig.addAuthority(new RouteAuthority(path, roles));
        return this;
    }

    public SecurityConfig addRouteAuthority(String path, String role, HttpMethod httpMethod) {
        this.coreSecurityConfig.addAuthority(new RouteAuthority(path, role, new HttpMethod[]{httpMethod}));
        return this;
    }

    public SecurityConfig addRouteAuthority(String path, String role, List<HttpMethod> httpMethods) {
        httpMethods.forEach(httpMethod -> this.coreSecurityConfig.addAuthority(new RouteAuthority(path, role, new HttpMethod[]{httpMethod})));
        return this;
    }

    public void build() {
        this.coreSecurityConfig.isCalled();
    }
}

