/*
 * Decompiled with CFR 0.152.
 */
package tech.lastbox.lastshield.basicauth.service;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Optional;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import tech.lastbox.lastshield.basicauth.dto.UserDTO;
import tech.lastbox.lastshield.basicauth.entity.User;
import tech.lastbox.lastshield.basicauth.exception.DuplicatedUserException;
import tech.lastbox.lastshield.basicauth.exception.UnregisteredUserException;
import tech.lastbox.lastshield.basicauth.exception.UsernameNotFoundException;
import tech.lastbox.lastshield.basicauth.repository.UserRepository;

@Service
@ConditionalOnProperty(name={"lastshield.basicauth"}, havingValue="true")
@Schema(description="Service for managing user-related operations, including user creation, login, and updates.")
public class UserService {
    private final UserRepository userRepository;
    private final PasswordEncoder passwordEncoder;

    public UserService(UserRepository userRepository, PasswordEncoder passwordEncoder) {
        this.userRepository = userRepository;
        this.passwordEncoder = passwordEncoder;
    }

    @Schema(description="Finds a user by their username. Throws UsernameNotFoundException if the user does not exist.")
    public User findUserByUsername(String username) throws UsernameNotFoundException {
        Optional<User> userOptional = this.userRepository.findUserByUsername(username);
        if (userOptional.isEmpty()) {
            throw new UsernameNotFoundException();
        }
        return userOptional.get();
    }

    @Schema(description="Creates a new user. Throws DuplicatedUserException if the username already exists.")
    public User createUser(String name, String username, String rawPassword) throws DuplicatedUserException {
        if (this.userRepository.existsUserByUsername(username)) {
            throw new DuplicatedUserException();
        }
        return (User)this.userRepository.save(new User(name, username, this.passwordEncoder.encode((CharSequence)rawPassword)));
    }

    @Schema(description="Attempts to log in with the given username and raw password.")
    public Optional<User> login(String username, String rawPassword) {
        return this.userRepository.findUserByUsername(username).filter(user -> this.passwordEncoder.matches((CharSequence)rawPassword, user.getPassword()));
    }

    @Schema(description="Retrieves all users as UserDTO objects.")
    public List<UserDTO> getUsersAsDTO() {
        return this.userRepository.findAllUsersAsDTO();
    }

    @Schema(description="Updates the user details. Throws UnregisteredUserException if the user is not registered.")
    public User updateUser(User user) throws UnregisteredUserException {
        if (user.getId() == null || user.getId() == 0L) {
            throw new UnregisteredUserException("User not registered to update.");
        }
        return (User)this.userRepository.save(user);
    }
}

