/*
 * Decompiled with CFR 0.152.
 */
package tech.lastbox.lastshield.basicauth.mapper;

import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import tech.lastbox.lastshield.basicauth.dto.UserDTO;
import tech.lastbox.lastshield.basicauth.entity.User;
import tech.lastbox.lastshield.basicauth.repository.UserRepository;

@Component
@ConditionalOnProperty(name={"lastshield.basicauth"}, havingValue="true")
@Schema(description="Mapper for converting UserDTO to User entity and vice versa.")
public class UserMapper {
    private final UserRepository userRepository;

    public UserMapper(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Schema(description="Converts a UserDTO into a User entity.")
    public User toEntity(@Schema(description="The UserDTO object containing the user information.") UserDTO userDTO) {
        return this.userRepository.findUserById(userDTO.id()).get();
    }

    @Schema(description="Converts a User entity into a UserDTO object.")
    public UserDTO toDto(@Schema(description="The User entity object containing the user information.") User user) {
        return new UserDTO(user.getId(), user.getName(), user.getUsername(), user.getRole());
    }
}

