/*
 * Decompiled with CFR 0.152.
 */
package tech.lastbox.lastshield.basicauth.enviroment;

import io.swagger.v3.oas.annotations.media.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import tech.lastbox.lastshield.basicauth.enviroment.InvalidIssuerException;
import tech.lastbox.lastshield.basicauth.enviroment.InvalidSecretKeyException;

@Component
@ConfigurationProperties(prefix="lastshield.basicauth")
@ConditionalOnProperty(name={"lastshield.basicauth"}, havingValue="true")
@Schema(description="Configuration properties for Basic Authentication in the application.")
public class BasicAuthProperties {
    @Schema(description="Issuer of the token, typically the system generating the token.", example="MyAuthSystem")
    private String issuer;
    @Schema(description="Secret key used for signing and verifying tokens.", example="SuperSecretKey12345")
    private String secretKey;
    @Schema(description="Name of the administrator user.", example="Admin")
    private String adminName = "Admin";
    @Schema(description="Username of the administrator user.", example="admin")
    private String adminUsername = "admin";
    @Schema(description="Password of the administrator user.", example="admin")
    private String adminPassword = "admin";
    private final Logger logger = LoggerFactory.getLogger(BasicAuthProperties.class);

    @Schema(description="Gets the issuer of the token.")
    public String getIssuer() {
        return this.issuer;
    }

    @Schema(description="Sets the issuer for the token.")
    public void setIssuer(String issuer) {
        if (issuer == null || issuer.isEmpty()) {
            this.logger.warn("Issuer cannot be null or empty, please set this in properties. \t\\u001B[33mProperty name: 'lastshield.basicauth.issuer'\\u001B[0m");
            throw new InvalidIssuerException("Issuer cannot be null or empty.");
        }
        this.issuer = issuer;
    }

    @Schema(description="Gets the secret key used for signing and verifying tokens.")
    public String getSecretKey() {
        return this.secretKey;
    }

    @Schema(description="Sets the secret key used for signing and verifying tokens.")
    public void setSecretKey(String secretKey) {
        if (secretKey == null || secretKey.isEmpty()) {
            this.logger.warn("SecretKey cannot be null or empty, please set this in properties. \t\\u001B[33mProperty name: 'lastshield.basicauth.secret_key'\\u001B[0m");
            throw new InvalidSecretKeyException("Secret Key cannot be null or empty.");
        }
        this.secretKey = secretKey;
    }

    @Schema(description="Gets the administrator's username.")
    public String getAdminUsername() {
        return this.adminUsername;
    }

    @Schema(description="Sets the administrator's username.")
    public void setAdminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
    }

    @Schema(description="Gets the administrator's password.")
    public String getAdminPassword() {
        return this.adminPassword;
    }

    @Schema(description="Sets the administrator's password.")
    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    @Schema(description="Gets the administrator's name.")
    public String getAdminName() {
        return this.adminName;
    }

    @Schema(description="Sets the administrator's name.")
    public void setAdminName(String adminName) {
        this.adminName = adminName;
    }
}

