/*
 * Decompiled with CFR 0.152.
 */
package tech.lastbox.lastshield.basicauth.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.Objects;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import tech.lastbox.lastshield.security.core.annotations.Password;
import tech.lastbox.lastshield.security.core.annotations.Username;

@Entity
@Table(name="users")
@ConditionalOnProperty(name={"lastshield.basicauth"}, havingValue="true")
public class User {
    @Id
    @GeneratedValue
    @Schema(description="The unique identifier of the user.", example="1")
    private Long id;
    @Schema(description="The full name of the user.", example="John Doe")
    private String name;
    @Username
    @Column(unique=true)
    @Schema(description="The unique username of the user.", example="johndoe")
    private String username;
    @Password
    @Schema(description="The password for the user's account.", example="password123")
    private String password;
    @Schema(description="The role of the user.", example="USER")
    private String role;

    public User() {
    }

    public User(String name, String username, String password) {
        this.name = name;
        this.username = username;
        this.password = password;
        this.role = "USER";
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public boolean equals(Object o) {
        if (!(o instanceof User)) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.username, user.username);
    }

    public int hashCode() {
        return Objects.hash(this.username);
    }
}

