/*
 * Decompiled with CFR 0.152.
 */
package tech.lastbox.lastshield.basicauth.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.time.LocalDateTime;
import java.util.Optional;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import tech.lastbox.jwt.JwtService;
import tech.lastbox.jwt.Token;
import tech.lastbox.lastshield.basicauth.dto.AuthResponseDTO;
import tech.lastbox.lastshield.basicauth.dto.ErrorResponse;
import tech.lastbox.lastshield.basicauth.dto.LoginRequest;
import tech.lastbox.lastshield.basicauth.dto.RegisterRequest;
import tech.lastbox.lastshield.basicauth.entity.User;
import tech.lastbox.lastshield.basicauth.enviroment.BasicAuthProperties;
import tech.lastbox.lastshield.basicauth.exception.DuplicatedUserException;
import tech.lastbox.lastshield.basicauth.service.UserService;

@RestController
@ConditionalOnProperty(name={"lastshield.basicauth"}, havingValue="true")
@Schema(description="Handles authentication and user registration for the application.")
public class AuthController {
    private final UserService userService;
    private final JwtService jwtService;
    private final BasicAuthProperties basicAuthProperties;

    public AuthController(UserService userService, JwtService jwtService, BasicAuthProperties basicAuthProperties) {
        this.userService = userService;
        this.jwtService = jwtService;
        this.basicAuthProperties = basicAuthProperties;
    }

    @PostMapping(value={"/login"})
    @Operation(summary="User Login", description="Authenticate a user by validating their credentials. If successful, returns a JWT token to be used for further authenticated requests.", operationId="loginUser", tags={"Authentication"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Login successful. Returns user details and a JWT token for authentication.", content={@Content(schema=@Schema(implementation=AuthResponseDTO.class))}), @ApiResponse(responseCode="401", description="Authentication failed. Incorrect username or password.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    public ResponseEntity<?> login(@RequestBody LoginRequest loginRequest) {
        Optional<User> userOptional = this.userService.login(loginRequest.username(), loginRequest.password());
        if (userOptional.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)new ErrorResponse("Invalid username or password.", HttpStatus.UNAUTHORIZED.toString(), LocalDateTime.now()));
        }
        User user = userOptional.get();
        Token token = this.jwtService.generateToken(loginRequest.username(), this.basicAuthProperties.getIssuer());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)new AuthResponseDTO(user.getId(), token.token(), "Login successful.", LocalDateTime.now()));
    }

    @PostMapping(value={"/register"})
    @Operation(summary="User Registration", description="Registers a new user in the database. If successful, returns a JWT token for immediate authentication.", operationId="registerUser", tags={"Authentication"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="User registration successful. Returns user details and a JWT token for authentication.", content={@Content(schema=@Schema(implementation=AuthResponseDTO.class))}), @ApiResponse(responseCode="409", description="Registration failed. The username is already in use.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    public ResponseEntity<?> register(@RequestBody RegisterRequest registerRequest) {
        try {
            User user = this.userService.createUser(registerRequest.name(), registerRequest.username(), registerRequest.password());
            Token token = this.jwtService.generateToken(user.getUsername(), this.basicAuthProperties.getIssuer());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)new AuthResponseDTO(user.getId(), token.token(), "User created successfully.", LocalDateTime.now()));
        }
        catch (DuplicatedUserException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)new ErrorResponse(e.getMessage(), HttpStatus.CONFLICT.toString(), LocalDateTime.now()));
        }
    }
}

