/*
 * Decompiled with CFR 0.152.
 */
package tech.lastbox.lastshield.basicauth.configuration;

import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import tech.lastbox.lastshield.security.SecurityConfig;

@Configuration
@ConditionalOnProperty(name={"lastshield.basicauth"}, havingValue="true")
@ComponentScan(basePackages={"tech.lastbox.lastshield"})
public class SecurityConfigInitializer {
    public SecurityConfigInitializer(SecurityConfig securityConfig) {
        securityConfig.corsAllowCredentials(true).corsAllowedOrigins(List.of("*")).corsAllowedMethods(List.of("*")).addRouteAuthority("/login").addRouteAuthority("/register").addRouteAuthority("/api-docs/**").addRouteAuthority("/swagger-ui/**").addRouteAuthority("/admin", "ADMIN").addRouteAuthority("/actuator", "ADMIN").addRouteAuthority("/actuator/**", "ADMIN").addRouteAuthority("/**", List.of("USER", "ADMIN")).setCsrfProtection(false);
        securityConfig.build();
    }
}

