/*
 * Decompiled with CFR 0.152.
 */
package tech.lastbox.lastshield.basicauth.configuration;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import tech.lastbox.jwt.ExpirationTimeUnit;
import tech.lastbox.jwt.JwtAlgorithm;
import tech.lastbox.jwt.JwtConfig;
import tech.lastbox.jwt.JwtService;
import tech.lastbox.jwt.TokenStore;
import tech.lastbox.lastshield.basicauth.enviroment.BasicAuthProperties;
import tech.lastbox.lastshield.basicauth.repository.TokenRepository;

@Configuration
public class JwtInitializer {
    private final BasicAuthProperties basicAuthProperties;
    private final TokenRepository tokenRepository;

    public JwtInitializer(BasicAuthProperties basicAuthProperties, TokenRepository tokenRepository) {
        this.basicAuthProperties = basicAuthProperties;
        this.tokenRepository = tokenRepository;
    }

    private JwtConfig getJwtConfig() {
        return new JwtConfig(JwtAlgorithm.HMAC256, this.basicAuthProperties.getSecretKey(), this.basicAuthProperties.getIssuer(), 7L, ExpirationTimeUnit.DAYS, (TokenStore)this.tokenRepository);
    }

    @Bean
    @ConditionalOnProperty(name={"lastshield.basicauth"}, havingValue="true")
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    @ConditionalOnProperty(name={"lastshield.basicauth"}, havingValue="true")
    public JwtService jwtService() {
        return new JwtService(this.getJwtConfig());
    }
}

