/*
 * Decompiled with CFR 0.152.
 */
package tech.lastbox.lastshield.basicauth.configuration;

import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.password.PasswordEncoder;
import tech.lastbox.lastshield.basicauth.entity.User;
import tech.lastbox.lastshield.basicauth.enviroment.BasicAuthProperties;
import tech.lastbox.lastshield.basicauth.repository.UserRepository;

@Configuration
@ConditionalOnProperty(name={"lastshield.basicauth"}, havingValue="true")
public class AdminConfig {
    private final UserRepository userRepository;
    private final PasswordEncoder passwordEncoder;
    private final BasicAuthProperties basicAuthProperties;
    private final Logger logger = LoggerFactory.getLogger(AdminConfig.class);

    public AdminConfig(UserRepository userRepository, PasswordEncoder passwordEncoder, BasicAuthProperties basicAuthProperties) {
        this.userRepository = userRepository;
        this.passwordEncoder = passwordEncoder;
        this.basicAuthProperties = basicAuthProperties;
    }

    @Bean
    @ConditionalOnProperty(name={"lastshield.basicauth"}, havingValue="true")
    public CommandLineRunner setupAdminUser() {
        return args -> {
            String adminName = this.basicAuthProperties.getAdminName();
            String adminUsername = this.basicAuthProperties.getAdminUsername();
            String adminPassword = this.basicAuthProperties.getAdminPassword();
            Optional<User> adminOptional = this.userRepository.findUserByRole("ADMIN");
            if (adminOptional.isEmpty()) {
                User adminUser = new User();
                adminUser.setName(adminName);
                adminUser.setUsername(adminUsername);
                adminUser.setPassword(this.passwordEncoder.encode((CharSequence)adminPassword));
                adminUser.setRole("ADMIN");
                this.userRepository.save(adminUser);
                this.logger.info("Admin user registered with login: {}", (Object)adminUsername);
            } else {
                User adminUser = adminOptional.get();
                if (!adminUser.getName().equals(adminName)) {
                    adminUser.setName(adminName);
                }
                if (!adminUser.getUsername().equals(adminUsername)) {
                    adminUser.setUsername(adminUsername);
                }
                if (!this.passwordEncoder.matches((CharSequence)adminPassword, adminUser.getPassword())) {
                    adminUser.setPassword(this.passwordEncoder.encode((CharSequence)adminPassword));
                }
                this.userRepository.save(adminUser);
                this.logger.info("Admin user is set with login: {}", (Object)adminUsername);
            }
        };
    }
}

