/*
 * Decompiled with CFR 0.152.
 */
package tech.lastbox.lastshield.basicauth.repository;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Optional;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import tech.lastbox.lastshield.basicauth.dto.UserDTO;
import tech.lastbox.lastshield.basicauth.entity.User;
import tech.lastbox.lastshield.security.core.annotations.UserHandler;

@UserHandler
@ConditionalOnProperty(name={"lastshield.basicauth"}, havingValue="true")
@Schema(description="Repository for handling user data and operations, including fetching users based on role, ID, and username.")
public interface UserRepository
extends JpaRepository<User, Long> {
    @Schema(description="Finds a user by their unique ID.")
    public Optional<User> findUserById(Long var1);

    @Schema(description="Finds a user by their unique username.")
    public Optional<User> findUserByUsername(String var1);

    @Schema(description="Checks if a user exists with the specified username.")
    public boolean existsUserByUsername(String var1);

    @Schema(description="Finds the first user by their role.")
    public Optional<User> findUserByRole(String var1);

    @Schema(description="Finds all users with the specified role.")
    public List<User> findUsersByRole(String var1);

    @Query(value="SELECT new tech.lastbox.lastshield.basicauth.dto.UserDTO(u.id, u.name, u.username, u.role) FROM User u WHERE u.role = 'USER'")
    @Schema(description="Retrieves all users with the 'USER' role as UserDTOs.")
    public List<UserDTO> findAllUsersAsDTO();
}

