/*
 * Decompiled with CFR 0.152.
 */
package tech.lastbox.lastshield.basicauth.configuration;

import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import tech.lastbox.jwt.ExpirationTimeUnit;
import tech.lastbox.jwt.JwtAlgorithm;
import tech.lastbox.jwt.JwtConfig;
import tech.lastbox.jwt.JwtService;
import tech.lastbox.jwt.TokenStore;
import tech.lastbox.lastshield.basicauth.enviroment.BasicAuthProperties;
import tech.lastbox.lastshield.basicauth.repository.TokenRepository;
import tech.lastbox.lastshield.security.SecurityConfig;

@Configuration
@ConditionalOnProperty(name={"lastshield.basicauth"}, havingValue="true")
public class SecurityConfigInitializer {
    private final BasicAuthProperties basicAuthProperties;
    private final TokenRepository tokenRepository;

    public SecurityConfigInitializer(BasicAuthProperties basicAuthProperties, TokenRepository tokenRepository) {
        this.basicAuthProperties = basicAuthProperties;
        this.tokenRepository = tokenRepository;
    }

    private JwtConfig getJwtConfig() {
        return new JwtConfig(JwtAlgorithm.HMAC256, this.basicAuthProperties.getSecretKey(), this.basicAuthProperties.getIssuer(), 7L, ExpirationTimeUnit.DAYS, (TokenStore)this.tokenRepository);
    }

    @Bean
    @ConditionalOnProperty(name={"lastshield.basicauth"}, havingValue="true")
    public SecurityConfig initializeSecurity(SecurityConfig securityConfig) {
        securityConfig.corsAllowCredentials(true).corsAllowedOrigins(List.of("*")).corsAllowedMethods(List.of("*")).addRouteAuthority("/login").addRouteAuthority("/register").addRouteAuthority("/api-docs/**").addRouteAuthority("/swagger-ui/**").addRouteAuthority("/admin", "ADMIN").addRouteAuthority("/actuator", "ADMIN").addRouteAuthority("/actuator/**", "ADMIN").addRouteAuthority("/**", List.of("USER", "ADMIN")).setCsrfProtection(false).build();
        return securityConfig;
    }

    @Bean
    @ConditionalOnProperty(name={"lastshield.basicauth"}, havingValue="true")
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    @ConditionalOnProperty(name={"lastshield.basicauth"}, havingValue="true")
    public JwtService jwtService() {
        return new JwtService(this.getJwtConfig());
    }
}

