/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.sample;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.luminis.quic.KwikVersion;
import net.luminis.quic.QuicConnection;
import net.luminis.quic.log.FileLogger;
import net.luminis.quic.log.Logger;
import net.luminis.quic.log.SysOutLogger;
import net.luminis.quic.server.ApplicationProtocolConnectionFactory;
import net.luminis.quic.server.ServerConnectionConfig;
import net.luminis.quic.server.ServerConnector;

public class SampleWebServer {
    private static void usageAndExit() {
        System.err.println("Usage: [--noRetry] cert file, cert key file, port number, www dir");
        System.exit(1);
    }

    public static void main(String[] rawArgs) throws Exception {
        File certificateKeyFile;
        File logDir;
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(rawArgs));
        if (args.size() < 4) {
            SampleWebServer.usageAndExit();
        }
        boolean withRetry = true;
        if (((String)args.get(0)).equals("--noRetry")) {
            withRetry = false;
            System.out.println("Retry disabled");
            args.remove(0);
        }
        if (args.size() < 4 || args.stream().anyMatch(arg -> arg.startsWith("-"))) {
            SampleWebServer.usageAndExit();
        }
        Object log = (logDir = new File("/logs")).exists() && logDir.isDirectory() && logDir.canWrite() ? new FileLogger(new File(logDir, "kwikserver.log")) : new SysOutLogger();
        log.timeFormat(Logger.TimeFormat.Long);
        log.logWarning(true);
        log.logInfo(true);
        File certificateFile = new File((String)args.get(0));
        if (!certificateFile.exists()) {
            System.err.println("Cannot open certificate file " + (String)args.get(0));
            System.exit(1);
        }
        if (!(certificateKeyFile = new File((String)args.get(1))).exists()) {
            System.err.println("Cannot open certificate file " + (String)args.get(1));
            System.exit(1);
        }
        int port = Integer.parseInt((String)args.get(2));
        File wwwDir = new File((String)args.get(3));
        if (!(wwwDir.exists() && wwwDir.isDirectory() && wwwDir.canRead())) {
            System.err.println("Cannot read www dir '" + wwwDir + "'");
            System.exit(1);
        }
        ArrayList<QuicConnection.QuicVersion> supportedVersions = new ArrayList<QuicConnection.QuicVersion>();
        supportedVersions.add(QuicConnection.QuicVersion.V1);
        supportedVersions.add(QuicConnection.QuicVersion.V2);
        ServerConnectionConfig serverConnectionConfig = ServerConnectionConfig.builder().maxIdleTimeoutInSeconds(30).maxUnidirectionalStreamBufferSize(1000000L).maxBidirectionalStreamBufferSize(1000000L).maxConnectionBufferSize(10000000L).maxOpenPeerInitiatedUnidirectionalStreams(10).maxOpenPeerInitiatedBidirectionalStreams(100).retryRequired(withRetry).connectionIdLength(8).build();
        ServerConnector serverConnector = ServerConnector.builder().withPort(port).withCertificate((InputStream)new FileInputStream(certificateFile), (InputStream)new FileInputStream(certificateKeyFile)).withSupportedVersions(supportedVersions).withConfiguration(serverConnectionConfig).withLogger((Logger)log).build();
        SampleWebServer.registerHttp3(serverConnector, wwwDir, supportedVersions, (Logger)log);
        serverConnector.start();
        log.info("Kwik server " + KwikVersion.getVersion() + " started; supported application protocols: " + serverConnector.getRegisteredApplicationProtocols());
    }

    private static void registerHttp3(ServerConnector serverConnector, File wwwDir, List<QuicConnection.QuicVersion> supportedVersions, Logger log) {
        ApplicationProtocolConnectionFactory http3ApplicationProtocolConnectionFactory = null;
        try {
            Class<?> http3FactoryClass = SampleWebServer.class.getClassLoader().loadClass("net.luminis.http3.server.Http3ApplicationProtocolFactory");
            http3ApplicationProtocolConnectionFactory = (ApplicationProtocolConnectionFactory)http3FactoryClass.getDeclaredConstructor(File.class).newInstance(wwwDir);
            log.info("Loading Flupke H3 server plugin");
            serverConnector.registerApplicationProtocol("h3", http3ApplicationProtocolConnectionFactory);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error("No H3 protocol: Flupke plugin not found.");
            System.exit(1);
        }
    }
}

