/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.sample.push;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.time.Duration;
import net.luminis.quic.QuicClientConnection;
import net.luminis.quic.QuicStream;
import net.luminis.quic.log.Logger;
import net.luminis.quic.log.SysOutLogger;

public class PushClient {
    private int serverPort;
    private QuicClientConnection connection;
    private SysOutLogger log;

    public static void main(String[] args) throws IOException, InterruptedException {
        PushClient client = null;
        try {
            client = new PushClient(Integer.parseInt(args[0]));
        }
        catch (Exception e) {
            System.err.println("Error: expected one argument: server-port-number");
            System.exit(1);
        }
        client.connect();
        Duration runningTime = Duration.ofMinutes(3L);
        Thread.sleep(runningTime.toMillis());
        System.out.println("Client has been running for " + runningTime + "; now terminating.");
        client.shutdown();
    }

    public PushClient(int serverPort) {
        this.serverPort = serverPort;
    }

    public void connect() throws IOException {
        this.log = new SysOutLogger();
        this.connection = QuicClientConnection.newBuilder().uri(URI.create("push://localhost:" + this.serverPort)).applicationProtocol("push").logger((Logger)this.log).noServerCertificateCheck().build();
        this.connection.setPeerInitiatedStreamCallback(quicStream -> new Thread(() -> this.handlePushMessages((QuicStream)quicStream)).start());
        this.connection.connect();
    }

    private void handlePushMessages(QuicStream quicStream) {
        System.out.println("Server opens stream.");
        BufferedReader inputStream = new BufferedReader(new InputStreamReader(quicStream.getInputStream()));
        try {
            while (true) {
                String line = inputStream.readLine();
                System.out.println("Received " + line);
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    private void shutdown() {
        this.connection.closeAndWait();
    }
}

