/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.sample.echo;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.List;
import net.luminis.quic.QuicClientConnection;
import net.luminis.quic.QuicConnection;
import net.luminis.quic.QuicSessionTicket;
import net.luminis.quic.QuicStream;
import net.luminis.quic.core.QuicSessionTicketImpl;
import net.luminis.quic.log.Logger;
import net.luminis.quic.log.SysOutLogger;

public class EchoClientUsing0RTT {
    public static final String SESSIONTICKET_FILE = "echoclientsessionticket.bin";
    private int serverPort;

    public static void main(String[] args) throws IOException {
        try {
            EchoClientUsing0RTT client = new EchoClientUsing0RTT(Integer.parseInt(args[0]));
            client.run();
        }
        catch (NumberFormatException e) {
            System.err.println("Error: expected one argument: server-port-number");
            System.exit(1);
        }
    }

    public EchoClientUsing0RTT(int serverPort) {
        this.serverPort = serverPort;
    }

    public void run() throws IOException {
        byte[] requestData = "hello mate!".getBytes(StandardCharsets.US_ASCII);
        SysOutLogger log = new SysOutLogger();
        log.logPackets(true);
        QuicClientConnection.Builder connectionBuilder = QuicClientConnection.newBuilder().uri(URI.create("echo://localhost:" + this.serverPort)).logger((Logger)log).version(QuicConnection.QuicVersion.V1).applicationProtocol("echo").noServerCertificateCheck();
        List<Object> earlyData = Collections.emptyList();
        try {
            byte[] ticketData = Files.readAllBytes(Path.of(SESSIONTICKET_FILE, new String[0]));
            connectionBuilder.sessionTicket((QuicSessionTicket)QuicSessionTicketImpl.deserialize((byte[])ticketData));
            earlyData = List.of(new QuicClientConnection.StreamEarlyData(requestData, true));
        }
        catch (IOException e) {
            System.err.println("Cannot read/load session ticket; will not be using 0-RTT!");
        }
        QuicClientConnection connection = connectionBuilder.build();
        List earlyStreams = connection.connect(earlyData);
        QuicStream quicStream = earlyStreams.stream().findAny().orElseGet(() -> {
            try {
                QuicStream s = connection.createStream(true);
                s.getOutputStream().write(requestData);
                s.getOutputStream().close();
                return s;
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        });
        System.out.print("Response from server: ");
        quicStream.getInputStream().transferTo(System.out);
        List newSessionTickets = connection.getNewSessionTickets();
        connection.closeAndWait();
        newSessionTickets.forEach(ticket -> {
            try {
                Files.write(Path.of(SESSIONTICKET_FILE, new String[0]), ticket.serialize(), StandardOpenOption.CREATE);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

