/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.sample;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import net.luminis.quic.QuicClientConnection;
import net.luminis.quic.QuicStream;
import net.luminis.quic.log.SysOutLogger;

public class SampleClient {
    public static void main(String[] args) throws Exception {
        SysOutLogger log = new SysOutLogger();
        log.logPackets(true);
        log.logInfo(true);
        QuicClientConnection.Builder builder = QuicClientConnection.newBuilder();
        QuicClientConnection connection = builder.uri(new URI(args[0])).applicationProtocol("hq-interop").build();
        connection.connect();
        QuicStream stream = connection.createStream(true);
        BufferedOutputStream outputStream = new BufferedOutputStream(stream.getOutputStream());
        outputStream.write("GET / \r\n".getBytes(StandardCharsets.UTF_8));
        outputStream.flush();
        long transferred = stream.getInputStream().transferTo(new FileOutputStream("kwik_client_output"));
        connection.close();
        System.out.println("Received " + transferred + " bytes.");
    }
}

