/*
 * Decompiled with CFR 0.152.
 */
package tech.kwik.sample.siduck;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import tech.kwik.core.QuicClientConnection;
import tech.kwik.core.log.Logger;
import tech.kwik.core.log.SysOutLogger;

public class SiduckClient {
    public static void main(String[] args) throws Exception {
        SysOutLogger log = new SysOutLogger();
        log.logInfo(true);
        QuicClientConnection.Builder builder = QuicClientConnection.newBuilder();
        QuicClientConnection connection = builder.logger((Logger)log).noServerCertificateCheck().enableDatagramExtension().uri(new URI(args[0])).applicationProtocol("siduck-00").build();
        connection.connect();
        if (!connection.isDatagramExtensionEnabled()) {
            System.out.println("Error: server did not advertise support for Datagram extension.");
            System.exit(1);
        }
        if (connection.maxDatagramDataSize() < 10) {
            System.out.println("Error: server does not support datagrams of at least 10 bytes.");
            System.exit(1);
        }
        connection.setDatagramHandler(data -> {
            String message = new String((byte[])data, StandardCharsets.UTF_8);
            System.out.println("Received datagram: \"" + message + "\"");
        });
        for (int i = 0; i < 3; ++i) {
            System.out.println("Sending datagram: \"quack\"");
            connection.sendDatagram("quack".getBytes(StandardCharsets.UTF_8));
            Thread.sleep(1000L);
        }
        connection.closeAndWait();
        System.out.println("Connection closed");
    }
}

