/*
 * Decompiled with CFR 0.152.
 */
package tech.kwik.sample.push;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import tech.kwik.core.QuicConnection;
import tech.kwik.core.QuicStream;
import tech.kwik.core.log.Logger;
import tech.kwik.core.log.SysOutLogger;
import tech.kwik.core.server.ApplicationProtocolConnection;
import tech.kwik.core.server.ApplicationProtocolConnectionFactory;
import tech.kwik.core.server.ServerConnectionConfig;
import tech.kwik.core.server.ServerConnector;

public class PushServer {
    private static void usageAndExit() {
        System.err.println("Usage: cert file, cert key file, port number");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3 || !Arrays.stream(args).limit(2L).allMatch(a -> new File((String)a).exists())) {
            PushServer.usageAndExit();
        }
        int port = -1;
        try {
            port = Integer.valueOf(args[2]);
        }
        catch (NumberFormatException noNumber) {
            PushServer.usageAndExit();
        }
        SysOutLogger log = new SysOutLogger();
        log.timeFormat(Logger.TimeFormat.Long);
        log.logWarning(true);
        log.logInfo(true);
        ServerConnectionConfig serverConnectionConfig = ServerConnectionConfig.builder().build();
        ServerConnector serverConnector = ServerConnector.builder().withPort(port).withCertificate((InputStream)new FileInputStream(args[0]), (InputStream)new FileInputStream(args[1])).withConfiguration(serverConnectionConfig).withLogger((Logger)log).build();
        PushServer.registerProtocolHandler(serverConnector, (Logger)log);
        serverConnector.start();
        log.info("Started (msg) push server on port " + port);
    }

    private static void registerProtocolHandler(ServerConnector serverConnector, Logger log) {
        serverConnector.registerApplicationProtocol("push", (ApplicationProtocolConnectionFactory)new PushProtocolConnectionFactory(log));
    }

    static class PushProtocolConnectionFactory
    implements ApplicationProtocolConnectionFactory {
        private Logger log;

        public PushProtocolConnectionFactory(Logger log) {
            this.log = log;
        }

        public ApplicationProtocolConnection createConnection(String protocol, QuicConnection quicConnection) {
            return new PushProtocolConnection(quicConnection, this.log);
        }
    }

    static class PushProtocolConnection
    implements ApplicationProtocolConnection {
        private Logger log;

        public PushProtocolConnection(QuicConnection quicConnection, Logger log) {
            this.log = log;
            System.out.println("New \"push protocol\" connection; will create (server initiated) stream to push messages to client.");
            try {
                QuicStream quicStream = quicConnection.createStream(false);
                new Thread(() -> this.generatePushMessages(quicStream), "pusher").start();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void generatePushMessages(QuicStream quicStream) {
            OutputStream outputStream = quicStream.getOutputStream();
            try {
                while (true) {
                    String currentDateTime = Instant.now().toString();
                    System.out.println("Pushing message " + currentDateTime);
                    outputStream.write(currentDateTime.getBytes(StandardCharsets.US_ASCII));
                    outputStream.write("\n".getBytes(StandardCharsets.US_ASCII));
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                System.out.println("Pushing messages terminated with exception " + e);
                return;
            }
        }
    }
}

