/*
 * Decompiled with CFR 0.152.
 */
package tech.kwik.sample;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import tech.kwik.core.KwikVersion;
import tech.kwik.core.QuicConnection;
import tech.kwik.core.log.FileLogger;
import tech.kwik.core.log.Logger;
import tech.kwik.core.log.SysOutLogger;
import tech.kwik.core.server.ApplicationProtocolConnectionFactory;
import tech.kwik.core.server.ServerConnectionConfig;
import tech.kwik.core.server.ServerConnector;

public class SampleWebServer {
    private static void usageAndExit() {
        System.err.println("Usage: [--noRetry] cert file, cert key file, port number, www dir");
        System.err.println("   or: [--noRetry] key store file, key store (and key) password, port number, www dir");
        System.exit(1);
    }

    public static void main(String[] rawArgs) throws Exception {
        File logDir;
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(rawArgs));
        if (args.size() < 4) {
            SampleWebServer.usageAndExit();
        }
        boolean withRetry = true;
        if (((String)args.get(0)).equals("--noRetry")) {
            withRetry = false;
            System.out.println("Retry disabled");
            args.remove(0);
        }
        if (args.size() < 4 || args.stream().anyMatch(arg -> arg.startsWith("-"))) {
            SampleWebServer.usageAndExit();
        }
        Object log = (logDir = new File("/logs")).exists() && logDir.isDirectory() && logDir.canWrite() ? new FileLogger(new File(logDir, "kwikserver.log")) : new SysOutLogger();
        log.timeFormat(Logger.TimeFormat.Long);
        log.logWarning(true);
        log.logInfo(true);
        File certificateFile = null;
        File certificateKeyFile = null;
        KeyStore keyStore = null;
        String keyStorePassword = null;
        if (new File((String)args.get(0)).exists() && new File((String)args.get(1)).exists()) {
            certificateFile = new File((String)args.get(0));
            certificateKeyFile = new File((String)args.get(1));
        } else if (new File((String)args.get(0)).exists()) {
            File keyStoreFile = new File((String)args.get(0));
            keyStorePassword = (String)args.get(1);
            keyStore = KeyStore.getInstance(keyStoreFile, keyStorePassword.toCharArray());
        } else {
            if (new File((String)args.get(1)).exists()) {
                System.err.println("Certificate / Keystore file does not exist or is not readable.");
            } else {
                System.err.println("Key file does not exist or is not readable.");
            }
            System.exit(1);
        }
        int port = Integer.parseInt((String)args.get(2));
        File wwwDir = new File((String)args.get(3));
        if (!(wwwDir.exists() && wwwDir.isDirectory() && wwwDir.canRead())) {
            System.err.println("Cannot read www dir '" + wwwDir + "'");
            System.exit(1);
        }
        ArrayList<QuicConnection.QuicVersion> supportedVersions = new ArrayList<QuicConnection.QuicVersion>();
        supportedVersions.add(QuicConnection.QuicVersion.V1);
        supportedVersions.add(QuicConnection.QuicVersion.V2);
        ServerConnectionConfig serverConnectionConfig = ServerConnectionConfig.builder().maxIdleTimeoutInSeconds(30).maxUnidirectionalStreamBufferSize(1000000L).maxBidirectionalStreamBufferSize(1000000L).maxConnectionBufferSize(10000000L).maxOpenPeerInitiatedUnidirectionalStreams(10).maxOpenPeerInitiatedBidirectionalStreams(100).retryRequired(withRetry).connectionIdLength(8).build();
        ServerConnector.Builder builder = ServerConnector.builder().withPort(port).withSupportedVersions(supportedVersions).withConfiguration(serverConnectionConfig).withLogger((Logger)log);
        if (certificateFile != null) {
            builder.withCertificate((InputStream)new FileInputStream(certificateFile), (InputStream)new FileInputStream(certificateKeyFile));
        } else {
            String alias = keyStore.aliases().nextElement();
            System.out.println("Using certificate with alias " + alias + " from keystore");
            builder.withKeyStore(keyStore, alias, keyStorePassword.toCharArray());
        }
        ServerConnector serverConnector = builder.build();
        SampleWebServer.registerHttp3(serverConnector, wwwDir, supportedVersions, (Logger)log);
        serverConnector.start();
        log.info("Kwik server " + KwikVersion.getVersion() + " started; supported application protocols: " + serverConnector.getRegisteredApplicationProtocols());
    }

    private static void registerHttp3(ServerConnector serverConnector, File wwwDir, List<QuicConnection.QuicVersion> supportedVersions, Logger log) {
        ApplicationProtocolConnectionFactory http3ApplicationProtocolConnectionFactory = null;
        try {
            Class<?> http3FactoryClass = SampleWebServer.class.getClassLoader().loadClass("net.luminis.http3.server.Http3ApplicationProtocolFactory");
            http3ApplicationProtocolConnectionFactory = (ApplicationProtocolConnectionFactory)http3FactoryClass.getDeclaredConstructor(File.class).newInstance(wwwDir);
            log.info("Loading Flupke H3 server plugin");
            serverConnector.registerApplicationProtocol("h3", http3ApplicationProtocolConnectionFactory);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error("No H3 protocol: Flupke plugin not found.");
            System.exit(1);
        }
    }
}

