/*
 * Decompiled with CFR 0.152.
 */
package tech.kwik.sample.echo;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import tech.kwik.core.QuicConnection;
import tech.kwik.core.QuicStream;
import tech.kwik.core.log.Logger;
import tech.kwik.core.log.SysOutLogger;
import tech.kwik.core.server.ApplicationProtocolConnection;
import tech.kwik.core.server.ApplicationProtocolConnectionFactory;
import tech.kwik.core.server.ServerConnectionConfig;
import tech.kwik.core.server.ServerConnector;

public class EchoServer {
    private static void usageAndExit() {
        System.err.println("Usage: cert file, cert key file, port number");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3 || !Arrays.stream(args).limit(2L).allMatch(a -> new File((String)a).exists())) {
            EchoServer.usageAndExit();
        }
        int port = -1;
        try {
            port = Integer.valueOf(args[2]);
        }
        catch (NumberFormatException noNumber) {
            EchoServer.usageAndExit();
        }
        SysOutLogger log = new SysOutLogger();
        log.timeFormat(Logger.TimeFormat.Long);
        log.logWarning(true);
        log.logInfo(true);
        ServerConnectionConfig serverConnectionConfig = ServerConnectionConfig.builder().maxOpenPeerInitiatedBidirectionalStreams(12).build();
        ServerConnector serverConnector = ServerConnector.builder().withPort(port).withCertificate((InputStream)new FileInputStream(args[0]), (InputStream)new FileInputStream(args[1])).withConfiguration(serverConnectionConfig).withLogger((Logger)log).build();
        EchoServer.registerProtocolHandler(serverConnector, (Logger)log);
        serverConnector.start();
        log.info("Started echo server on port " + port);
    }

    private static void registerProtocolHandler(ServerConnector serverConnector, Logger log) {
        serverConnector.registerApplicationProtocol("echo", (ApplicationProtocolConnectionFactory)new EchoProtocolConnectionFactory(log));
    }

    static class EchoProtocolConnectionFactory
    implements ApplicationProtocolConnectionFactory {
        private final Logger log;

        public EchoProtocolConnectionFactory(Logger log) {
            this.log = log;
        }

        public ApplicationProtocolConnection createConnection(String protocol, QuicConnection quicConnection) {
            return new EchoProtocolConnection(quicConnection, this.log);
        }

        public int maxConcurrentPeerInitiatedUnidirectionalStreams() {
            return 0;
        }

        public int maxConcurrentPeerInitiatedBidirectionalStreams() {
            return Integer.MAX_VALUE;
        }
    }

    static class EchoProtocolConnection
    implements ApplicationProtocolConnection {
        private Logger log;

        public EchoProtocolConnection(QuicConnection quicConnection, Logger log) {
            this.log = log;
        }

        public void acceptPeerInitiatedStream(QuicStream quicStream) {
            new Thread(() -> this.handleEchoRequest(quicStream)).start();
        }

        private void handleEchoRequest(QuicStream quicStream) {
            try {
                byte[] bytesRead = quicStream.getInputStream().readAllBytes();
                System.out.println("Read echo request with " + bytesRead.length + " bytes of data.");
                quicStream.getOutputStream().write(bytesRead);
                quicStream.getOutputStream().close();
            }
            catch (IOException e) {
                this.log.error("Reading quic stream failed", (Throwable)e);
            }
        }
    }
}

