/*
 * Decompiled with CFR 0.152.
 */
package tech.kwik.sample.siduck;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import tech.kwik.core.QuicConnection;
import tech.kwik.core.QuicConstants;
import tech.kwik.core.log.Logger;
import tech.kwik.core.log.SysOutLogger;
import tech.kwik.core.server.ApplicationProtocolConnection;
import tech.kwik.core.server.ApplicationProtocolConnectionFactory;
import tech.kwik.core.server.ServerConnectionConfig;
import tech.kwik.core.server.ServerConnector;

public class SiduckServer {
    private static void usageAndExit() {
        System.err.println("Usage: cert file, cert key file, port number");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3 || !Arrays.stream(args).limit(2L).allMatch(a -> new File((String)a).exists())) {
            SiduckServer.usageAndExit();
        }
        int port = -1;
        try {
            port = Integer.valueOf(args[2]);
        }
        catch (NumberFormatException noNumber) {
            SiduckServer.usageAndExit();
        }
        SysOutLogger log = new SysOutLogger();
        log.timeFormat(Logger.TimeFormat.Long);
        log.logWarning(true);
        log.logInfo(true);
        ServerConnectionConfig serverConnectionConfig = ServerConnectionConfig.builder().build();
        ServerConnector serverConnector = ServerConnector.builder().withPort(port).withCertificate((InputStream)new FileInputStream(args[0]), (InputStream)new FileInputStream(args[1])).withConfiguration(serverConnectionConfig).withLogger((Logger)log).build();
        SiduckServer.registerProtocolHandler(serverConnector, (Logger)log);
        serverConnector.start();
        log.info("Started Siduck server on port " + port);
    }

    private static void registerProtocolHandler(ServerConnector serverConnector, Logger log) {
        serverConnector.registerApplicationProtocol("siduck-00", (ApplicationProtocolConnectionFactory)new SiduckConnectionFactory(log));
    }

    static class SiduckConnectionFactory
    implements ApplicationProtocolConnectionFactory {
        private final Logger log;

        public SiduckConnectionFactory(Logger log) {
            this.log = log;
        }

        public boolean enableDatagramExtension() {
            return true;
        }

        public ApplicationProtocolConnection createConnection(String protocol, QuicConnection quicConnection) {
            if (!quicConnection.isDatagramExtensionEnabled()) {
                quicConnection.close(QuicConstants.TransportErrorCode.APPLICATION_ERROR, "Datagram extension not enabled");
                return null;
            }
            return new SiduckConnection(quicConnection, this.log);
        }

        public int maxConcurrentPeerInitiatedUnidirectionalStreams() {
            return 0;
        }

        public int maxConcurrentPeerInitiatedBidirectionalStreams() {
            return 0;
        }
    }

    static class SiduckConnection
    implements ApplicationProtocolConnection {
        private Logger log;
        private QuicConnection quicConnection;

        public SiduckConnection(QuicConnection quicConnection, Logger log) {
            this.log = log;
            this.quicConnection = quicConnection;
            this.quicConnection.setDatagramHandler(this::handleDatagram);
        }

        private void handleDatagram(byte[] data) {
            this.log.info("Received datagram with " + data.length + " bytes of data: \"" + new String(data) + "\"");
            this.quicConnection.sendDatagram("quack-ack".getBytes());
            this.log.info("Sent datagram with " + "quack-ack".length() + " bytes of data");
        }
    }
}

