/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.interop;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyStore;
import java.util.List;
import net.luminis.quic.KwikVersion;
import net.luminis.quic.QuicConnection;
import net.luminis.quic.log.FileLogger;
import net.luminis.quic.log.Logger;
import net.luminis.quic.log.SysOutLogger;
import net.luminis.quic.server.ApplicationProtocolConnectionFactory;
import net.luminis.quic.server.ServerConnectionConfig;
import net.luminis.quic.server.ServerConnector;
import net.luminis.quic.server.h09.Http09ApplicationProtocolFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class InteropServer {
    private static void usageAndExit() {
        System.err.println("Usage: [--noRetry] cert file, cert key file, port number [www dir]");
        System.exit(1);
    }

    public static void main(String[] rawArgs) throws Exception {
        File logDir;
        Options cmdLineOptions = new Options();
        cmdLineOptions.addOption(null, "noRetry", false, "disable always use retry");
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(cmdLineOptions, rawArgs);
        }
        catch (ParseException argError) {
            System.out.println("Invalid argument: " + argError.getMessage());
            InteropServer.usageAndExit();
        }
        List args = cmd.getArgList();
        if (args.size() < 3) {
            InteropServer.usageAndExit();
        }
        Object log = (logDir = new File("/logs")).exists() && logDir.isDirectory() && logDir.canWrite() ? new FileLogger(new File(logDir, "kwikserver.log")) : new SysOutLogger();
        log.timeFormat(Logger.TimeFormat.Long);
        log.logWarning(true);
        log.logInfo(true);
        File keyStoreFile = new File((String)args.get(0));
        if (!keyStoreFile.exists()) {
            System.err.println("Cannot open keystore file " + (String)args.get(0));
            System.exit(1);
        }
        String certificateAlias = (String)args.get(1);
        String keyStorePassword = (String)args.get(2);
        String keyPassword = (String)args.get(3);
        KeyStore keyStore = KeyStore.getInstance(keyStoreFile, keyStorePassword.toCharArray());
        int port = Integer.parseInt((String)args.get(4));
        File wwwDir = null;
        if (!(args.size() <= 5 || (wwwDir = new File((String)args.get(5))).exists() && wwwDir.isDirectory() && wwwDir.canRead())) {
            System.err.println("Cannot read www dir '" + wwwDir + "'");
            System.exit(1);
        }
        List<QuicConnection.QuicVersion> supportedVersions = List.of(QuicConnection.QuicVersion.V1);
        ServerConnectionConfig serverConnectionConfig = ServerConnectionConfig.builder().maxIdleTimeoutInSeconds(30).maxUnidirectionalStreamBufferSize(1000000L).maxBidirectionalStreamBufferSize(1000000L).maxConnectionBufferSize(10000000L).maxOpenPeerInitiatedUnidirectionalStreams(10).maxOpenPeerInitiatedBidirectionalStreams(100).retryRequired(!cmd.hasOption("noRetry")).connectionIdLength(8).build();
        ServerConnector serverConnector = ServerConnector.builder().withPort(port).withKeyStore(keyStore, certificateAlias, keyPassword.toCharArray()).withSupportedVersions(supportedVersions).withConfiguration(serverConnectionConfig).withLogger((Logger)log).build();
        if (wwwDir != null) {
            InteropServer.registerApplicationLayerProtocols(serverConnector, wwwDir, (Logger)log);
        }
        serverConnector.start();
        log.info("Kwik server " + KwikVersion.getVersion() + " started; supported application protocols: " + serverConnector.getRegisteredApplicationProtocols());
    }

    private static void registerApplicationLayerProtocols(ServerConnector serverConnector, File wwwDir, Logger log) {
        ApplicationProtocolConnectionFactory http3ApplicationProtocolConnectionFactory = null;
        try {
            Class<?> http3FactoryClass = InteropServer.class.getClassLoader().loadClass("net.luminis.http3.server.Http3ApplicationProtocolFactory");
            http3ApplicationProtocolConnectionFactory = (ApplicationProtocolConnectionFactory)http3FactoryClass.getDeclaredConstructor(File.class).newInstance(wwwDir);
            log.info("Loading Flupke H3 server plugin");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException http3FactoryClass) {
            // empty catch block
        }
        Http09ApplicationProtocolFactory http09ApplicationProtocolFactory = new Http09ApplicationProtocolFactory(wwwDir);
        ApplicationProtocolConnectionFactory http3ApplicationProtocolFactory = http3ApplicationProtocolConnectionFactory;
        String protocol = "hq-interop";
        serverConnector.registerApplicationProtocol(protocol, (ApplicationProtocolConnectionFactory)http09ApplicationProtocolFactory);
        if (http3ApplicationProtocolFactory != null) {
            String h3Protocol = protocol.replace("hq-interop", "h3");
            serverConnector.registerApplicationProtocol(h3Protocol, http3ApplicationProtocolFactory);
        }
    }
}

