/*
 * Decompiled with CFR 0.152.
 */
package tech.kwik.interop;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyStore;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import tech.kwik.core.KwikVersion;
import tech.kwik.core.QuicConnection;
import tech.kwik.core.log.FileLogger;
import tech.kwik.core.log.Logger;
import tech.kwik.core.log.NullLogger;
import tech.kwik.core.log.SysOutLogger;
import tech.kwik.core.server.ApplicationProtocolConnectionFactory;
import tech.kwik.core.server.ServerConnectionConfig;
import tech.kwik.core.server.ServerConnector;
import tech.kwik.h09.server.Http09ApplicationProtocolFactory;

public class InteropServer {
    private static void usageAndExit() {
        System.err.println("Usage: [--noRetry] keystore-file cert-alias keystore-password, key-password, port-number [www dir]");
        System.exit(1);
    }

    public static void main(String[] rawArgs) throws Exception {
        File logDir;
        String testcase = System.getenv("TESTCASE");
        if (testcase == null) {
            testcase = "";
        }
        Options cmdLineOptions = new Options();
        cmdLineOptions.addOption(null, "noRetry", false, "disable always use retry");
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(cmdLineOptions, rawArgs);
        }
        catch (ParseException argError) {
            System.out.println("Invalid argument: " + argError.getMessage());
            InteropServer.usageAndExit();
        }
        List args = cmd.getArgList();
        if (args.size() < 3) {
            InteropServer.usageAndExit();
        }
        Object log = (logDir = new File("/logs")).exists() && logDir.isDirectory() && logDir.canWrite() && !testcase.equals("transfer") ? new FileLogger(new File(logDir, "kwikserver.log")) : (testcase.equals("transfer") ? new NullLogger() : new SysOutLogger());
        log.timeFormat(Logger.TimeFormat.Long);
        log.logWarning(true);
        log.logInfo(true);
        File keyStoreFile = new File((String)args.get(0));
        if (!keyStoreFile.exists()) {
            System.err.println("Cannot open keystore file " + (String)args.get(0));
            System.exit(1);
        }
        String certificateAlias = (String)args.get(1);
        String keyStorePassword = (String)args.get(2);
        String keyPassword = (String)args.get(3);
        KeyStore keyStore = KeyStore.getInstance(keyStoreFile, keyStorePassword.toCharArray());
        if (keyStore.getCertificateChain(certificateAlias) == null) {
            System.err.println("Certificate alias '" + certificateAlias + "' not found in keystore");
            System.exit(1);
        }
        int port = Integer.parseInt((String)args.get(4));
        File wwwDir = null;
        if (!(args.size() <= 5 || (wwwDir = new File((String)args.get(5))).exists() && wwwDir.isDirectory() && wwwDir.canRead())) {
            System.err.println("Cannot read www dir '" + wwwDir + "'");
            System.exit(1);
        }
        List<QuicConnection.QuicVersion> supportedVersions = List.of(QuicConnection.QuicVersion.V1, QuicConnection.QuicVersion.V2);
        ServerConnectionConfig serverConnectionConfig = ServerConnectionConfig.builder().maxIdleTimeoutInSeconds(30).maxUnidirectionalStreamBufferSize(1000000L).maxBidirectionalStreamBufferSize(1000000L).maxConnectionBufferSize(10000000L).maxOpenPeerInitiatedUnidirectionalStreams(10).maxOpenPeerInitiatedBidirectionalStreams(100).retryRequired(!cmd.hasOption("noRetry")).connectionIdLength(8).build();
        ServerConnector serverConnector = ServerConnector.builder().withPort(port).withKeyStore(keyStore, certificateAlias, keyPassword.toCharArray()).withSupportedVersions(supportedVersions).withConfiguration(serverConnectionConfig).withLogger((Logger)log).build();
        if (wwwDir != null) {
            InteropServer.registerApplicationLayerProtocols(serverConnector, wwwDir, (Logger)log);
        }
        serverConnector.start();
        log.info("Kwik server " + KwikVersion.getVersion() + " started; supported application protocols: " + serverConnector.getRegisteredApplicationProtocols());
    }

    private static void registerApplicationLayerProtocols(ServerConnector serverConnector, File wwwDir, Logger log) {
        ApplicationProtocolConnectionFactory http3ApplicationProtocolConnectionFactory = null;
        try {
            http3ApplicationProtocolConnectionFactory = InteropServer.http3FlupkeOld(wwwDir);
            if (http3ApplicationProtocolConnectionFactory == null) {
                http3ApplicationProtocolConnectionFactory = InteropServer.http3FlupkeNew(wwwDir);
            }
            log.info("Loading Flupke H3 server plugin");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.info("No Flupke H3 server plugin." + e.getMessage());
        }
        Http09ApplicationProtocolFactory http09ApplicationProtocolFactory = new Http09ApplicationProtocolFactory(wwwDir);
        ApplicationProtocolConnectionFactory http3ApplicationProtocolFactory = http3ApplicationProtocolConnectionFactory;
        String protocol = "hq-interop";
        serverConnector.registerApplicationProtocol(protocol, (ApplicationProtocolConnectionFactory)http09ApplicationProtocolFactory);
        if (http3ApplicationProtocolFactory != null) {
            String h3Protocol = protocol.replace("hq-interop", "h3");
            serverConnector.registerApplicationProtocol(h3Protocol, http3ApplicationProtocolFactory);
        }
    }

    private static ApplicationProtocolConnectionFactory http3FlupkeOld(File wwwDir) {
        try {
            Class<?> http3FactoryClass = InteropServer.class.getClassLoader().loadClass("net.luminis.http3.server.Http3ApplicationProtocolFactory");
            return (ApplicationProtocolConnectionFactory)http3FactoryClass.getDeclaredConstructor(File.class).newInstance(wwwDir);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            System.out.println("Old Flupke plugin not found");
            return null;
        }
    }

    private static ApplicationProtocolConnectionFactory http3FlupkeNew(File wwwDir) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Class<?> http3FactoryClass = InteropServer.class.getClassLoader().loadClass("tech.kwik.flupke.sample.kwik.Http3SimpleFileServerApplicationProtocolConnectionFactory");
        return (ApplicationProtocolConnectionFactory)http3FactoryClass.getDeclaredConstructor(File.class).newInstance(wwwDir);
    }
}

