/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.tls.extension;

import java.nio.ByteBuffer;
import net.luminis.tls.TlsConstants;
import net.luminis.tls.alert.DecodeErrorException;
import net.luminis.tls.extension.PreSharedKeyExtension;

public class ServerPreSharedKeyExtension
extends PreSharedKeyExtension {
    private int selectedIdentity;

    public ServerPreSharedKeyExtension(int selectedIdentity) {
        this.selectedIdentity = selectedIdentity;
    }

    public ServerPreSharedKeyExtension() {
    }

    public ServerPreSharedKeyExtension parse(ByteBuffer buffer) throws DecodeErrorException {
        this.parseExtensionHeader(buffer, TlsConstants.ExtensionType.pre_shared_key, 2);
        this.selectedIdentity = buffer.getShort();
        return this;
    }

    @Override
    public byte[] getBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(6);
        buffer.putShort(TlsConstants.ExtensionType.pre_shared_key.value);
        buffer.putShort((short)2);
        buffer.putShort((short)this.selectedIdentity);
        return buffer.array();
    }

    public int getSelectedIdentity() {
        return this.selectedIdentity;
    }
}

