/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.tls.extension;

import java.nio.ByteBuffer;
import net.luminis.tls.TlsConstants;
import net.luminis.tls.alert.DecodeErrorException;

public abstract class Extension {
    protected int parseExtensionHeader(ByteBuffer buffer, TlsConstants.ExtensionType expectedType, int minimumExtensionSize) throws DecodeErrorException {
        return this.parseExtensionHeader(buffer, expectedType.value, minimumExtensionSize);
    }

    protected int parseExtensionHeader(ByteBuffer buffer, int expectedType, int minimumExtensionSize) throws DecodeErrorException {
        if (buffer.limit() - buffer.position() < 4) {
            throw new DecodeErrorException("extension underflow");
        }
        int extensionType = buffer.getShort() & 0xFFFF;
        if (extensionType != expectedType) {
            throw new IllegalStateException();
        }
        int extensionDataLength = buffer.getShort() & 0xFFFF;
        if (extensionDataLength < minimumExtensionSize) {
            throw new DecodeErrorException(this.getClass().getSimpleName() + " can't be less than " + minimumExtensionSize + " bytes");
        }
        if (buffer.limit() - buffer.position() < extensionDataLength) {
            throw new DecodeErrorException("extension underflow");
        }
        return extensionDataLength;
    }

    public abstract byte[] getBytes();
}

