/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.tls;

import java.security.Principal;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.luminis.tls.HostnameVerifier;
import net.luminis.tls.Logger;

public class DefaultHostnameVerifier
implements HostnameVerifier {
    @Override
    public boolean verify(String serverName, X509Certificate serverCertificate) {
        try {
            boolean matchesSan = this.verifyHostname(serverName, serverCertificate.getSubjectAlternativeNames());
            if (matchesSan) {
                return true;
            }
            return this.verifyHostname(serverName, serverCertificate.getSubjectDN());
        }
        catch (CertificateParsingException e) {
            Logger.debug("Retrieving subject alternative names from certificate failed");
            return false;
        }
    }

    boolean verifyHostname(String serverName, Collection<List<?>> subjectAlternativeNames) {
        if (subjectAlternativeNames == null) {
            return false;
        }
        return subjectAlternativeNames.stream().filter(entryList -> entryList.get(0).equals(2)).map(entryList -> (String)entryList.get(1)).anyMatch(dnsName -> this.serverNameMatchesDnsName(serverName, (String)dnsName));
    }

    boolean serverNameMatchesDnsName(String serverName, String dnsName) {
        if (serverName == null || dnsName == null || serverName.trim().equals("") || dnsName.trim().equals("")) {
            throw new IllegalArgumentException("can't be null or empty");
        }
        if (dnsName.startsWith("*.")) {
            int firstFullStop = serverName.indexOf(".");
            boolean matchesTrueSubdomain = firstFullStop > 0 && serverName.substring(firstFullStop + 1).equals(dnsName.substring(2));
            boolean matchesFullDomain = serverName.equals(dnsName.substring(2));
            return matchesTrueSubdomain || matchesFullDomain;
        }
        return serverName.equals(dnsName);
    }

    boolean verifyHostname(String serverName, Principal subjectDN) {
        String dn = subjectDN.getName();
        boolean matches = Arrays.stream(dn.split(",")).map(s -> s.trim()).filter(s -> s.startsWith("CN=")).map(s -> s.replace("CN=", "")).allMatch(s -> s.equals(serverName));
        return matches;
    }
}

