/*
 * Copyright © 2023 Peter Doornbosch
 *
 * This file is part of Agent15, an implementation of TLS 1.3 in Java.
 *
 * Agent15 is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * Agent15 is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package net.luminis.tls.compat;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamCompat {

    public static byte[] readAllBytes(InputStream in) throws IOException {
        byte[] buf = new byte[8192];
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int bytesRead;

        while ((bytesRead = in.read(buf)) != -1) {
            bout.write(buf, 0, bytesRead);
        }
        bout.flush();

        return bout.toByteArray();
    }
}
