/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.testutils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;

public class TestFileHelper {
    public static String readTestFile(String name, Class<?> type) {
        return TestFileHelper.readTestFile(TestFileHelper.getResourcesDir(name, type));
    }

    private static String readTestFile(Path file) {
        try {
            return Files.readString(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Path getResourcesDir(String name, Class<?> type) {
        return TestFileHelper.getResourcesDir(type).resolve(name);
    }

    private static Path getResourcesDir(Class<?> type) {
        return TestFileHelper.getProjectDir().resolve("src/test/resources").resolve(String.join((CharSequence)"/", type.getName().split("\\.")));
    }

    public static Path getProjectDir() {
        Path dir = Path.of("", new String[0]).toAbsolutePath();
        while (!Files.exists(dir.resolve("build.gradle"), new LinkOption[0])) {
            if (!Objects.isNull(dir = dir.getParent())) continue;
            throw new RuntimeException("Cannot find project directory");
        }
        return dir;
    }
}

