/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.testutils;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;

public class MalformedFileCreator {
    public static final byte[] MALFORMED_UTF8_BYTES = new byte[]{-128, -127};

    public static void createMalformedFile(Path file) {
        MalformedFileCreator.createFile(file, true, null, null);
    }

    public static void createMalformedFile(Path file, String startContent, String endContent) {
        MalformedFileCreator.createFile(file, true, startContent, endContent);
    }

    public static void createRegularFile(Path file, String content) {
        MalformedFileCreator.createFile(file, false, content, null);
    }

    public static void createFile(Path file, boolean malformed) {
        MalformedFileCreator.createFile(file, malformed, null, null);
    }

    public static void createFile(Path file, boolean malformed, String startContent, String endContent) {
        try (OutputStream out = Files.newOutputStream(file, new OpenOption[0]);){
            if (Objects.nonNull(startContent)) {
                MalformedFileCreator.write(out, startContent);
            }
            if (malformed) {
                out.write(MALFORMED_UTF8_BYTES);
            }
            if (Objects.nonNull(endContent)) {
                MalformedFileCreator.write(out, endContent);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void write(OutputStream out, String startContent) throws IOException {
        out.write(startContent.getBytes(StandardCharsets.UTF_8));
    }
}

