/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models.linesofcode;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import tech.kronicle.sdk.models.ComponentState;
import tech.kronicle.sdk.models.linesofcode.FileExtensionCount;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=LinesOfCodeStateBuilder.class)
public final class LinesOfCodeState
implements ComponentState {
    public static final String TYPE = "lines-of-code";
    private final String type = "lines-of-code";
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*")
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*") String pluginId;
    private final String id;
    private final Integer count;
    private final @NotNull List<@Valid FileExtensionCount> fileExtensionCounts;

    public LinesOfCodeState(String pluginId, Integer count, List<@Valid FileExtensionCount> fileExtensionCounts) {
        this.id = null;
        this.pluginId = pluginId;
        this.count = count;
        this.fileExtensionCounts = ListUtils.createUnmodifiableList(fileExtensionCounts);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static LinesOfCodeStateBuilder builder() {
        return new LinesOfCodeStateBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LinesOfCodeStateBuilder toBuilder() {
        return new LinesOfCodeStateBuilder().pluginId(this.pluginId).count(this.count).fileExtensionCounts(this.fileExtensionCounts);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getType() {
        return this.type;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Integer getCount() {
        return this.count;
    }

    @NotNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public @NotNull List<@Valid FileExtensionCount> getFileExtensionCounts() {
        return this.fileExtensionCounts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LinesOfCodeState)) {
            return false;
        }
        LinesOfCodeState other = (LinesOfCodeState)o;
        Integer this$count = this.getCount();
        Integer other$count = other.getCount();
        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<FileExtensionCount> this$fileExtensionCounts = this.getFileExtensionCounts();
        List<FileExtensionCount> other$fileExtensionCounts = other.getFileExtensionCounts();
        return !(this$fileExtensionCounts == null ? other$fileExtensionCounts != null : !((Object)this$fileExtensionCounts).equals(other$fileExtensionCounts));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<FileExtensionCount> $fileExtensionCounts = this.getFileExtensionCounts();
        result = result * 59 + ($fileExtensionCounts == null ? 43 : ((Object)$fileExtensionCounts).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "LinesOfCodeState(type=" + this.getType() + ", pluginId=" + this.getPluginId() + ", id=" + this.getId() + ", count=" + this.getCount() + ", fileExtensionCounts=" + this.getFileExtensionCounts() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LinesOfCodeState withPluginId(String pluginId) {
        return this.pluginId == pluginId ? this : new LinesOfCodeState(pluginId, this.count, this.fileExtensionCounts);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LinesOfCodeState withCount(Integer count) {
        return this.count == count ? this : new LinesOfCodeState(this.pluginId, count, this.fileExtensionCounts);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LinesOfCodeState withFileExtensionCounts(@NotNull List<@Valid FileExtensionCount> fileExtensionCounts) {
        return this.fileExtensionCounts == fileExtensionCounts ? this : new LinesOfCodeState(this.pluginId, this.count, fileExtensionCounts);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class LinesOfCodeStateBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String pluginId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Integer count;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid FileExtensionCount> fileExtensionCounts;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        LinesOfCodeStateBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LinesOfCodeStateBuilder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LinesOfCodeStateBuilder count(Integer count) {
            this.count = count;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LinesOfCodeStateBuilder fileExtensionCounts(@NotNull List<@Valid FileExtensionCount> fileExtensionCounts) {
            this.fileExtensionCounts = fileExtensionCounts;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LinesOfCodeState build() {
            return new LinesOfCodeState(this.pluginId, this.count, this.fileExtensionCounts);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "LinesOfCodeState.LinesOfCodeStateBuilder(pluginId=" + this.pluginId + ", count=" + this.count + ", fileExtensionCounts=" + this.fileExtensionCounts + ")";
        }
    }
}

