/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models.doc;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import tech.kronicle.sdk.models.ComponentState;
import tech.kronicle.sdk.models.Tag;
import tech.kronicle.sdk.models.doc.DocFile;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=DocStateBuilder.class)
public final class DocState
implements ComponentState {
    public static final String TYPE = "doc";
    private final String type = "doc";
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*")
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*") String pluginId;
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*")
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*") String id;
    private final String dir;
    private final String file;
    @NotBlank
    private final String name;
    private final String description;
    private final String notes;
    private final List<Tag> tags;
    @NotNull
    private final List<DocFile> files;

    public DocState(String pluginId, String id, String dir, String file, String name, String description, String notes, List<@Valid Tag> tags, List<@Valid DocFile> files) {
        this.pluginId = pluginId;
        this.id = id;
        this.dir = dir;
        this.file = file;
        this.name = name;
        this.description = description;
        this.notes = notes;
        this.tags = ListUtils.createUnmodifiableList(tags);
        this.files = ListUtils.createUnmodifiableList(files);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static DocStateBuilder builder() {
        return new DocStateBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DocStateBuilder toBuilder() {
        return new DocStateBuilder().pluginId(this.pluginId).id(this.id).dir(this.dir).file(this.file).name(this.name).description(this.description).notes(this.notes).tags(this.tags).files(this.files);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getType() {
        return this.type;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDir() {
        return this.dir;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getFile() {
        return this.file;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDescription() {
        return this.description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getNotes() {
        return this.notes;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<Tag> getTags() {
        return this.tags;
    }

    @NotNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<DocFile> getFiles() {
        return this.files;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocState)) {
            return false;
        }
        DocState other = (DocState)o;
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$dir = this.getDir();
        String other$dir = other.getDir();
        if (this$dir == null ? other$dir != null : !this$dir.equals(other$dir)) {
            return false;
        }
        String this$file = this.getFile();
        String other$file = other.getFile();
        if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$notes = this.getNotes();
        String other$notes = other.getNotes();
        if (this$notes == null ? other$notes != null : !this$notes.equals(other$notes)) {
            return false;
        }
        List<Tag> this$tags = this.getTags();
        List<Tag> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List<DocFile> this$files = this.getFiles();
        List<DocFile> other$files = other.getFiles();
        return !(this$files == null ? other$files != null : !((Object)this$files).equals(other$files));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $dir = this.getDir();
        result = result * 59 + ($dir == null ? 43 : $dir.hashCode());
        String $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : $file.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $notes = this.getNotes();
        result = result * 59 + ($notes == null ? 43 : $notes.hashCode());
        List<Tag> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List<DocFile> $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "DocState(type=" + this.getType() + ", pluginId=" + this.getPluginId() + ", id=" + this.getId() + ", dir=" + this.getDir() + ", file=" + this.getFile() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", notes=" + this.getNotes() + ", tags=" + this.getTags() + ", files=" + this.getFiles() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DocState withPluginId(String pluginId) {
        return this.pluginId == pluginId ? this : new DocState(pluginId, this.id, this.dir, this.file, this.name, this.description, this.notes, this.tags, this.files);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DocState withId(String id) {
        return this.id == id ? this : new DocState(this.pluginId, id, this.dir, this.file, this.name, this.description, this.notes, this.tags, this.files);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DocState withDir(String dir) {
        return this.dir == dir ? this : new DocState(this.pluginId, this.id, dir, this.file, this.name, this.description, this.notes, this.tags, this.files);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DocState withFile(String file) {
        return this.file == file ? this : new DocState(this.pluginId, this.id, this.dir, file, this.name, this.description, this.notes, this.tags, this.files);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DocState withName(String name) {
        return this.name == name ? this : new DocState(this.pluginId, this.id, this.dir, this.file, name, this.description, this.notes, this.tags, this.files);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DocState withDescription(String description) {
        return this.description == description ? this : new DocState(this.pluginId, this.id, this.dir, this.file, this.name, description, this.notes, this.tags, this.files);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DocState withNotes(String notes) {
        return this.notes == notes ? this : new DocState(this.pluginId, this.id, this.dir, this.file, this.name, this.description, notes, this.tags, this.files);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DocState withTags(List<Tag> tags) {
        return this.tags == tags ? this : new DocState(this.pluginId, this.id, this.dir, this.file, this.name, this.description, this.notes, tags, this.files);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DocState withFiles(@NotNull List<DocFile> files) {
        return this.files == files ? this : new DocState(this.pluginId, this.id, this.dir, this.file, this.name, this.description, this.notes, this.tags, files);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class DocStateBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String pluginId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String id;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String dir;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String file;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String name;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String description;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String notes;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<Tag> tags;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<DocFile> files;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        DocStateBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DocStateBuilder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DocStateBuilder id(String id) {
            this.id = id;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DocStateBuilder dir(String dir) {
            this.dir = dir;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DocStateBuilder file(String file) {
            this.file = file;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DocStateBuilder name(String name) {
            this.name = name;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DocStateBuilder description(String description) {
            this.description = description;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DocStateBuilder notes(String notes) {
            this.notes = notes;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DocStateBuilder tags(List<Tag> tags) {
            this.tags = tags;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DocStateBuilder files(@NotNull List<DocFile> files) {
            this.files = files;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DocState build() {
            return new DocState(this.pluginId, this.id, this.dir, this.file, this.name, this.description, this.notes, this.tags, this.files);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "DocState.DocStateBuilder(pluginId=" + this.pluginId + ", id=" + this.id + ", dir=" + this.dir + ", file=" + this.file + ", name=" + this.name + ", description=" + this.description + ", notes=" + this.notes + ", tags=" + this.tags + ", files=" + this.files + ")";
        }
    }
}

