/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import tech.kronicle.sdk.models.ComponentState;
import tech.kronicle.sdk.models.SoftwareRepository;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=SoftwareRepositoriesStateBuilder.class)
public final class SoftwareRepositoriesState
implements ComponentState {
    public static final String TYPE = "software-repositories";
    private final String type = "software-repositories";
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*")
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*") String pluginId;
    private final String id;
    private final @NotNull List<@Valid SoftwareRepository> softwareRepositories;

    public SoftwareRepositoriesState(String pluginId, List<@Valid SoftwareRepository> softwareRepositories) {
        this.id = null;
        this.pluginId = pluginId;
        this.softwareRepositories = ListUtils.createUnmodifiableList(softwareRepositories);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static SoftwareRepositoriesStateBuilder builder() {
        return new SoftwareRepositoriesStateBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SoftwareRepositoriesStateBuilder toBuilder() {
        return new SoftwareRepositoriesStateBuilder().pluginId(this.pluginId).softwareRepositories(this.softwareRepositories);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getType() {
        return this.type;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @NotNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public @NotNull List<@Valid SoftwareRepository> getSoftwareRepositories() {
        return this.softwareRepositories;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SoftwareRepositoriesState)) {
            return false;
        }
        SoftwareRepositoriesState other = (SoftwareRepositoriesState)o;
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<SoftwareRepository> this$softwareRepositories = this.getSoftwareRepositories();
        List<SoftwareRepository> other$softwareRepositories = other.getSoftwareRepositories();
        return !(this$softwareRepositories == null ? other$softwareRepositories != null : !((Object)this$softwareRepositories).equals(other$softwareRepositories));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<SoftwareRepository> $softwareRepositories = this.getSoftwareRepositories();
        result = result * 59 + ($softwareRepositories == null ? 43 : ((Object)$softwareRepositories).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "SoftwareRepositoriesState(type=" + this.getType() + ", pluginId=" + this.getPluginId() + ", id=" + this.getId() + ", softwareRepositories=" + this.getSoftwareRepositories() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SoftwareRepositoriesState withPluginId(String pluginId) {
        return this.pluginId == pluginId ? this : new SoftwareRepositoriesState(pluginId, this.softwareRepositories);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SoftwareRepositoriesState withSoftwareRepositories(@NotNull List<@Valid SoftwareRepository> softwareRepositories) {
        return this.softwareRepositories == softwareRepositories ? this : new SoftwareRepositoriesState(this.pluginId, softwareRepositories);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class SoftwareRepositoriesStateBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String pluginId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid SoftwareRepository> softwareRepositories;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SoftwareRepositoriesStateBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SoftwareRepositoriesStateBuilder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SoftwareRepositoriesStateBuilder softwareRepositories(@NotNull List<@Valid SoftwareRepository> softwareRepositories) {
            this.softwareRepositories = softwareRepositories;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SoftwareRepositoriesState build() {
            return new SoftwareRepositoriesState(this.pluginId, this.softwareRepositories);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "SoftwareRepositoriesState.SoftwareRepositoriesStateBuilder(pluginId=" + this.pluginId + ", softwareRepositories=" + this.softwareRepositories + ")";
        }
    }
}

