/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDateTime;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import tech.kronicle.sdk.models.ComponentEnvironmentState;
import tech.kronicle.sdk.models.LogLevelSummary;
import tech.kronicle.sdk.models.LogSummary;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=LogSummaryStateBuilder.class)
public final class LogSummaryState
implements ComponentEnvironmentState {
    public static final String TYPE = "log-summary";
    private final String type = "log-summary";
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*")
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*") String pluginId;
    private final String id;
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*")
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*") String environmentId;
    @NotEmpty
    private final String name;
    @NotNull
    private final LocalDateTime startTimestamp;
    @NotNull
    private final LocalDateTime endTimestamp;
    private final List<@NotNull @Valid LogLevelSummary> levels;
    private final List<@NotNull @Valid LogSummary> comparisons;
    @NotNull
    private final LocalDateTime updateTimestamp;

    public LogSummaryState(String pluginId, String environmentId, String name, LocalDateTime startTimestamp, LocalDateTime endTimestamp, List<LogLevelSummary> levels, List<LogSummary> comparisons, LocalDateTime updateTimestamp) {
        this.id = null;
        this.pluginId = pluginId;
        this.environmentId = environmentId;
        this.name = name;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.levels = ListUtils.createUnmodifiableList(levels);
        this.comparisons = ListUtils.createUnmodifiableList(comparisons);
        this.updateTimestamp = updateTimestamp;
    }

    public static LogSummaryState of(String pluginId, String environmentId, LogSummary logSummary, List<LogSummary> comparisons, LocalDateTime updateTimestamp) {
        return new LogSummaryState(pluginId, environmentId, logSummary.getName(), logSummary.getStartTimestamp(), logSummary.getEndTimestamp(), logSummary.getLevels(), comparisons, updateTimestamp);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static LogSummaryStateBuilder builder() {
        return new LogSummaryStateBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LogSummaryStateBuilder toBuilder() {
        return new LogSummaryStateBuilder().pluginId(this.pluginId).environmentId(this.environmentId).name(this.name).startTimestamp(this.startTimestamp).endTimestamp(this.endTimestamp).levels(this.levels).comparisons(this.comparisons).updateTimestamp(this.updateTimestamp);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getType() {
        return this.type;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @NotNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDateTime getStartTimestamp() {
        return this.startTimestamp;
    }

    @NotNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDateTime getEndTimestamp() {
        return this.endTimestamp;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@NotNull @Valid LogLevelSummary> getLevels() {
        return this.levels;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@NotNull @Valid LogSummary> getComparisons() {
        return this.comparisons;
    }

    @NotNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDateTime getUpdateTimestamp() {
        return this.updateTimestamp;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogSummaryState)) {
            return false;
        }
        LogSummaryState other = (LogSummaryState)o;
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$environmentId = this.getEnvironmentId();
        String other$environmentId = other.getEnvironmentId();
        if (this$environmentId == null ? other$environmentId != null : !this$environmentId.equals(other$environmentId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        LocalDateTime this$startTimestamp = this.getStartTimestamp();
        LocalDateTime other$startTimestamp = other.getStartTimestamp();
        if (this$startTimestamp == null ? other$startTimestamp != null : !((Object)this$startTimestamp).equals(other$startTimestamp)) {
            return false;
        }
        LocalDateTime this$endTimestamp = this.getEndTimestamp();
        LocalDateTime other$endTimestamp = other.getEndTimestamp();
        if (this$endTimestamp == null ? other$endTimestamp != null : !((Object)this$endTimestamp).equals(other$endTimestamp)) {
            return false;
        }
        List<LogLevelSummary> this$levels = this.getLevels();
        List<LogLevelSummary> other$levels = other.getLevels();
        if (this$levels == null ? other$levels != null : !((Object)this$levels).equals(other$levels)) {
            return false;
        }
        List<LogSummary> this$comparisons = this.getComparisons();
        List<LogSummary> other$comparisons = other.getComparisons();
        if (this$comparisons == null ? other$comparisons != null : !((Object)this$comparisons).equals(other$comparisons)) {
            return false;
        }
        LocalDateTime this$updateTimestamp = this.getUpdateTimestamp();
        LocalDateTime other$updateTimestamp = other.getUpdateTimestamp();
        return !(this$updateTimestamp == null ? other$updateTimestamp != null : !((Object)this$updateTimestamp).equals(other$updateTimestamp));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $environmentId = this.getEnvironmentId();
        result = result * 59 + ($environmentId == null ? 43 : $environmentId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        LocalDateTime $startTimestamp = this.getStartTimestamp();
        result = result * 59 + ($startTimestamp == null ? 43 : ((Object)$startTimestamp).hashCode());
        LocalDateTime $endTimestamp = this.getEndTimestamp();
        result = result * 59 + ($endTimestamp == null ? 43 : ((Object)$endTimestamp).hashCode());
        List<LogLevelSummary> $levels = this.getLevels();
        result = result * 59 + ($levels == null ? 43 : ((Object)$levels).hashCode());
        List<LogSummary> $comparisons = this.getComparisons();
        result = result * 59 + ($comparisons == null ? 43 : ((Object)$comparisons).hashCode());
        LocalDateTime $updateTimestamp = this.getUpdateTimestamp();
        result = result * 59 + ($updateTimestamp == null ? 43 : ((Object)$updateTimestamp).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "LogSummaryState(type=" + this.getType() + ", pluginId=" + this.getPluginId() + ", id=" + this.getId() + ", environmentId=" + this.getEnvironmentId() + ", name=" + this.getName() + ", startTimestamp=" + this.getStartTimestamp() + ", endTimestamp=" + this.getEndTimestamp() + ", levels=" + this.getLevels() + ", comparisons=" + this.getComparisons() + ", updateTimestamp=" + this.getUpdateTimestamp() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LogSummaryState withPluginId(String pluginId) {
        return this.pluginId == pluginId ? this : new LogSummaryState(pluginId, this.environmentId, this.name, this.startTimestamp, this.endTimestamp, this.levels, this.comparisons, this.updateTimestamp);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LogSummaryState withEnvironmentId(String environmentId) {
        return this.environmentId == environmentId ? this : new LogSummaryState(this.pluginId, environmentId, this.name, this.startTimestamp, this.endTimestamp, this.levels, this.comparisons, this.updateTimestamp);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LogSummaryState withName(String name) {
        return this.name == name ? this : new LogSummaryState(this.pluginId, this.environmentId, name, this.startTimestamp, this.endTimestamp, this.levels, this.comparisons, this.updateTimestamp);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LogSummaryState withStartTimestamp(@NotNull LocalDateTime startTimestamp) {
        return this.startTimestamp == startTimestamp ? this : new LogSummaryState(this.pluginId, this.environmentId, this.name, startTimestamp, this.endTimestamp, this.levels, this.comparisons, this.updateTimestamp);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LogSummaryState withEndTimestamp(@NotNull LocalDateTime endTimestamp) {
        return this.endTimestamp == endTimestamp ? this : new LogSummaryState(this.pluginId, this.environmentId, this.name, this.startTimestamp, endTimestamp, this.levels, this.comparisons, this.updateTimestamp);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LogSummaryState withLevels(List<@NotNull @Valid LogLevelSummary> levels) {
        return this.levels == levels ? this : new LogSummaryState(this.pluginId, this.environmentId, this.name, this.startTimestamp, this.endTimestamp, levels, this.comparisons, this.updateTimestamp);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LogSummaryState withComparisons(List<@NotNull @Valid LogSummary> comparisons) {
        return this.comparisons == comparisons ? this : new LogSummaryState(this.pluginId, this.environmentId, this.name, this.startTimestamp, this.endTimestamp, this.levels, comparisons, this.updateTimestamp);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LogSummaryState withUpdateTimestamp(@NotNull LocalDateTime updateTimestamp) {
        return this.updateTimestamp == updateTimestamp ? this : new LogSummaryState(this.pluginId, this.environmentId, this.name, this.startTimestamp, this.endTimestamp, this.levels, this.comparisons, updateTimestamp);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class LogSummaryStateBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String pluginId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String environmentId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String name;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDateTime startTimestamp;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDateTime endTimestamp;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@NotNull @Valid LogLevelSummary> levels;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@NotNull @Valid LogSummary> comparisons;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDateTime updateTimestamp;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        LogSummaryStateBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LogSummaryStateBuilder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LogSummaryStateBuilder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LogSummaryStateBuilder name(String name) {
            this.name = name;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LogSummaryStateBuilder startTimestamp(@NotNull LocalDateTime startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LogSummaryStateBuilder endTimestamp(@NotNull LocalDateTime endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LogSummaryStateBuilder levels(List<@NotNull @Valid LogLevelSummary> levels) {
            this.levels = levels;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LogSummaryStateBuilder comparisons(List<@NotNull @Valid LogSummary> comparisons) {
            this.comparisons = comparisons;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LogSummaryStateBuilder updateTimestamp(@NotNull LocalDateTime updateTimestamp) {
            this.updateTimestamp = updateTimestamp;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LogSummaryState build() {
            return new LogSummaryState(this.pluginId, this.environmentId, this.name, this.startTimestamp, this.endTimestamp, this.levels, this.comparisons, this.updateTimestamp);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "LogSummaryState.LogSummaryStateBuilder(pluginId=" + this.pluginId + ", environmentId=" + this.environmentId + ", name=" + this.name + ", startTimestamp=" + this.startTimestamp + ", endTimestamp=" + this.endTimestamp + ", levels=" + this.levels + ", comparisons=" + this.comparisons + ", updateTimestamp=" + this.updateTimestamp + ")";
        }
    }
}

