/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import tech.kronicle.sdk.models.DiagramState;
import tech.kronicle.sdk.models.GraphEdge;
import tech.kronicle.sdk.models.GraphNode;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=GraphStateBuilder.class)
public final class GraphState
implements DiagramState {
    public static final String TYPE = "graph";
    private final String type = "graph";
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*")
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*") String pluginId;
    private final String id;
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*")
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*") String environmentId;
    private final List<@Valid GraphNode> nodes;
    private final List<@Valid GraphEdge> edges;
    private final Integer sampleSize;

    public GraphState(String pluginId, String environmentId, List<GraphNode> nodes, List<GraphEdge> edges, Integer sampleSize) {
        this.id = null;
        this.pluginId = pluginId;
        this.environmentId = environmentId;
        this.nodes = ListUtils.createUnmodifiableList(nodes);
        this.edges = ListUtils.createUnmodifiableList(edges);
        this.sampleSize = sampleSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static GraphStateBuilder builder() {
        return new GraphStateBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GraphStateBuilder toBuilder() {
        return new GraphStateBuilder().pluginId(this.pluginId).environmentId(this.environmentId).nodes(this.nodes).edges(this.edges).sampleSize(this.sampleSize);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getType() {
        return this.type;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid GraphNode> getNodes() {
        return this.nodes;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid GraphEdge> getEdges() {
        return this.edges;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Integer getSampleSize() {
        return this.sampleSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GraphState)) {
            return false;
        }
        GraphState other = (GraphState)o;
        Integer this$sampleSize = this.getSampleSize();
        Integer other$sampleSize = other.getSampleSize();
        if (this$sampleSize == null ? other$sampleSize != null : !((Object)this$sampleSize).equals(other$sampleSize)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$environmentId = this.getEnvironmentId();
        String other$environmentId = other.getEnvironmentId();
        if (this$environmentId == null ? other$environmentId != null : !this$environmentId.equals(other$environmentId)) {
            return false;
        }
        List<GraphNode> this$nodes = this.getNodes();
        List<GraphNode> other$nodes = other.getNodes();
        if (this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes)) {
            return false;
        }
        List<GraphEdge> this$edges = this.getEdges();
        List<GraphEdge> other$edges = other.getEdges();
        return !(this$edges == null ? other$edges != null : !((Object)this$edges).equals(other$edges));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $sampleSize = this.getSampleSize();
        result = result * 59 + ($sampleSize == null ? 43 : ((Object)$sampleSize).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $environmentId = this.getEnvironmentId();
        result = result * 59 + ($environmentId == null ? 43 : $environmentId.hashCode());
        List<GraphNode> $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
        List<GraphEdge> $edges = this.getEdges();
        result = result * 59 + ($edges == null ? 43 : ((Object)$edges).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "GraphState(type=" + this.getType() + ", pluginId=" + this.getPluginId() + ", id=" + this.getId() + ", environmentId=" + this.getEnvironmentId() + ", nodes=" + this.getNodes() + ", edges=" + this.getEdges() + ", sampleSize=" + this.getSampleSize() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GraphState withPluginId(String pluginId) {
        return this.pluginId == pluginId ? this : new GraphState(pluginId, this.environmentId, this.nodes, this.edges, this.sampleSize);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GraphState withEnvironmentId(String environmentId) {
        return this.environmentId == environmentId ? this : new GraphState(this.pluginId, environmentId, this.nodes, this.edges, this.sampleSize);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GraphState withNodes(List<@Valid GraphNode> nodes) {
        return this.nodes == nodes ? this : new GraphState(this.pluginId, this.environmentId, nodes, this.edges, this.sampleSize);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GraphState withEdges(List<@Valid GraphEdge> edges) {
        return this.edges == edges ? this : new GraphState(this.pluginId, this.environmentId, this.nodes, edges, this.sampleSize);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GraphState withSampleSize(Integer sampleSize) {
        return this.sampleSize == sampleSize ? this : new GraphState(this.pluginId, this.environmentId, this.nodes, this.edges, sampleSize);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class GraphStateBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String pluginId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String environmentId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid GraphNode> nodes;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid GraphEdge> edges;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Integer sampleSize;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        GraphStateBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GraphStateBuilder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GraphStateBuilder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GraphStateBuilder nodes(List<@Valid GraphNode> nodes) {
            this.nodes = nodes;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GraphStateBuilder edges(List<@Valid GraphEdge> edges) {
            this.edges = edges;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GraphStateBuilder sampleSize(Integer sampleSize) {
            this.sampleSize = sampleSize;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GraphState build() {
            return new GraphState(this.pluginId, this.environmentId, this.nodes, this.edges, this.sampleSize);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "GraphState.GraphStateBuilder(pluginId=" + this.pluginId + ", environmentId=" + this.environmentId + ", nodes=" + this.nodes + ", edges=" + this.edges + ", sampleSize=" + this.sampleSize + ")";
        }
    }
}

