/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDateTime;
import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import tech.kronicle.sdk.models.GraphEdgeDuration;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=GraphEdgeBuilder.class)
public final class GraphEdge {
    @Min(value=0L)
    private final @Min(value=0L) Integer sourceIndex;
    @NotNull
    @Min(value=0L)
    private final @NotNull @Min(value=0L) Integer targetIndex;
    @NotNull
    private final @NotNull List<@NotNull @Min(value=0L) Integer> relatedIndexes;
    @NotBlank
    private final String type;
    private final String label;
    private final String description;
    private final Integer sampleSize;
    private final LocalDateTime startTimestamp;
    private final LocalDateTime endTimestamp;
    private final GraphEdgeDuration duration;

    public GraphEdge(Integer sourceIndex, Integer targetIndex, List<Integer> relatedIndexes, String type, String label, String description, Integer sampleSize, LocalDateTime startTimestamp, LocalDateTime endTimestamp, GraphEdgeDuration duration) {
        this.sourceIndex = sourceIndex;
        this.targetIndex = targetIndex;
        this.relatedIndexes = ListUtils.createUnmodifiableList(relatedIndexes);
        this.type = type;
        this.label = label;
        this.description = description;
        this.sampleSize = sampleSize;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.duration = duration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static GraphEdgeBuilder builder() {
        return new GraphEdgeBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GraphEdgeBuilder toBuilder() {
        return new GraphEdgeBuilder().sourceIndex(this.sourceIndex).targetIndex(this.targetIndex).relatedIndexes(this.relatedIndexes).type(this.type).label(this.label).description(this.description).sampleSize(this.sampleSize).startTimestamp(this.startTimestamp).endTimestamp(this.endTimestamp).duration(this.duration);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Integer getSourceIndex() {
        return this.sourceIndex;
    }

    @NotNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Integer getTargetIndex() {
        return this.targetIndex;
    }

    @NotNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public @NotNull List<@NotNull @Min(value=0L) Integer> getRelatedIndexes() {
        return this.relatedIndexes;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getType() {
        return this.type;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getLabel() {
        return this.label;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDescription() {
        return this.description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Integer getSampleSize() {
        return this.sampleSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDateTime getStartTimestamp() {
        return this.startTimestamp;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDateTime getEndTimestamp() {
        return this.endTimestamp;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GraphEdgeDuration getDuration() {
        return this.duration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GraphEdge)) {
            return false;
        }
        GraphEdge other = (GraphEdge)o;
        Integer this$sourceIndex = this.getSourceIndex();
        Integer other$sourceIndex = other.getSourceIndex();
        if (this$sourceIndex == null ? other$sourceIndex != null : !((Object)this$sourceIndex).equals(other$sourceIndex)) {
            return false;
        }
        Integer this$targetIndex = this.getTargetIndex();
        Integer other$targetIndex = other.getTargetIndex();
        if (this$targetIndex == null ? other$targetIndex != null : !((Object)this$targetIndex).equals(other$targetIndex)) {
            return false;
        }
        Integer this$sampleSize = this.getSampleSize();
        Integer other$sampleSize = other.getSampleSize();
        if (this$sampleSize == null ? other$sampleSize != null : !((Object)this$sampleSize).equals(other$sampleSize)) {
            return false;
        }
        List<Integer> this$relatedIndexes = this.getRelatedIndexes();
        List<Integer> other$relatedIndexes = other.getRelatedIndexes();
        if (this$relatedIndexes == null ? other$relatedIndexes != null : !((Object)this$relatedIndexes).equals(other$relatedIndexes)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        LocalDateTime this$startTimestamp = this.getStartTimestamp();
        LocalDateTime other$startTimestamp = other.getStartTimestamp();
        if (this$startTimestamp == null ? other$startTimestamp != null : !((Object)this$startTimestamp).equals(other$startTimestamp)) {
            return false;
        }
        LocalDateTime this$endTimestamp = this.getEndTimestamp();
        LocalDateTime other$endTimestamp = other.getEndTimestamp();
        if (this$endTimestamp == null ? other$endTimestamp != null : !((Object)this$endTimestamp).equals(other$endTimestamp)) {
            return false;
        }
        GraphEdgeDuration this$duration = this.getDuration();
        GraphEdgeDuration other$duration = other.getDuration();
        return !(this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $sourceIndex = this.getSourceIndex();
        result = result * 59 + ($sourceIndex == null ? 43 : ((Object)$sourceIndex).hashCode());
        Integer $targetIndex = this.getTargetIndex();
        result = result * 59 + ($targetIndex == null ? 43 : ((Object)$targetIndex).hashCode());
        Integer $sampleSize = this.getSampleSize();
        result = result * 59 + ($sampleSize == null ? 43 : ((Object)$sampleSize).hashCode());
        List<Integer> $relatedIndexes = this.getRelatedIndexes();
        result = result * 59 + ($relatedIndexes == null ? 43 : ((Object)$relatedIndexes).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        LocalDateTime $startTimestamp = this.getStartTimestamp();
        result = result * 59 + ($startTimestamp == null ? 43 : ((Object)$startTimestamp).hashCode());
        LocalDateTime $endTimestamp = this.getEndTimestamp();
        result = result * 59 + ($endTimestamp == null ? 43 : ((Object)$endTimestamp).hashCode());
        GraphEdgeDuration $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "GraphEdge(sourceIndex=" + this.getSourceIndex() + ", targetIndex=" + this.getTargetIndex() + ", relatedIndexes=" + this.getRelatedIndexes() + ", type=" + this.getType() + ", label=" + this.getLabel() + ", description=" + this.getDescription() + ", sampleSize=" + this.getSampleSize() + ", startTimestamp=" + this.getStartTimestamp() + ", endTimestamp=" + this.getEndTimestamp() + ", duration=" + this.getDuration() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GraphEdge withSourceIndex(Integer sourceIndex) {
        return this.sourceIndex == sourceIndex ? this : new GraphEdge(sourceIndex, this.targetIndex, this.relatedIndexes, this.type, this.label, this.description, this.sampleSize, this.startTimestamp, this.endTimestamp, this.duration);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GraphEdge withTargetIndex(@NotNull Integer targetIndex) {
        return this.targetIndex == targetIndex ? this : new GraphEdge(this.sourceIndex, targetIndex, this.relatedIndexes, this.type, this.label, this.description, this.sampleSize, this.startTimestamp, this.endTimestamp, this.duration);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GraphEdge withRelatedIndexes(@NotNull @NotNull List<@NotNull @Min(value=0L) Integer> relatedIndexes) {
        return this.relatedIndexes == relatedIndexes ? this : new GraphEdge(this.sourceIndex, this.targetIndex, relatedIndexes, this.type, this.label, this.description, this.sampleSize, this.startTimestamp, this.endTimestamp, this.duration);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GraphEdge withType(String type) {
        return this.type == type ? this : new GraphEdge(this.sourceIndex, this.targetIndex, this.relatedIndexes, type, this.label, this.description, this.sampleSize, this.startTimestamp, this.endTimestamp, this.duration);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GraphEdge withLabel(String label) {
        return this.label == label ? this : new GraphEdge(this.sourceIndex, this.targetIndex, this.relatedIndexes, this.type, label, this.description, this.sampleSize, this.startTimestamp, this.endTimestamp, this.duration);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GraphEdge withDescription(String description) {
        return this.description == description ? this : new GraphEdge(this.sourceIndex, this.targetIndex, this.relatedIndexes, this.type, this.label, description, this.sampleSize, this.startTimestamp, this.endTimestamp, this.duration);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GraphEdge withSampleSize(Integer sampleSize) {
        return this.sampleSize == sampleSize ? this : new GraphEdge(this.sourceIndex, this.targetIndex, this.relatedIndexes, this.type, this.label, this.description, sampleSize, this.startTimestamp, this.endTimestamp, this.duration);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GraphEdge withStartTimestamp(LocalDateTime startTimestamp) {
        return this.startTimestamp == startTimestamp ? this : new GraphEdge(this.sourceIndex, this.targetIndex, this.relatedIndexes, this.type, this.label, this.description, this.sampleSize, startTimestamp, this.endTimestamp, this.duration);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GraphEdge withEndTimestamp(LocalDateTime endTimestamp) {
        return this.endTimestamp == endTimestamp ? this : new GraphEdge(this.sourceIndex, this.targetIndex, this.relatedIndexes, this.type, this.label, this.description, this.sampleSize, this.startTimestamp, endTimestamp, this.duration);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GraphEdge withDuration(GraphEdgeDuration duration) {
        return this.duration == duration ? this : new GraphEdge(this.sourceIndex, this.targetIndex, this.relatedIndexes, this.type, this.label, this.description, this.sampleSize, this.startTimestamp, this.endTimestamp, duration);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class GraphEdgeBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Integer sourceIndex;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Integer targetIndex;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@NotNull @Min(value=0L) Integer> relatedIndexes;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String type;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String label;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String description;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Integer sampleSize;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDateTime startTimestamp;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDateTime endTimestamp;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private GraphEdgeDuration duration;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        GraphEdgeBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GraphEdgeBuilder sourceIndex(Integer sourceIndex) {
            this.sourceIndex = sourceIndex;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GraphEdgeBuilder targetIndex(@NotNull Integer targetIndex) {
            this.targetIndex = targetIndex;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GraphEdgeBuilder relatedIndexes(@NotNull @NotNull List<@NotNull @Min(value=0L) Integer> relatedIndexes) {
            this.relatedIndexes = relatedIndexes;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GraphEdgeBuilder type(String type) {
            this.type = type;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GraphEdgeBuilder label(String label) {
            this.label = label;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GraphEdgeBuilder description(String description) {
            this.description = description;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GraphEdgeBuilder sampleSize(Integer sampleSize) {
            this.sampleSize = sampleSize;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GraphEdgeBuilder startTimestamp(LocalDateTime startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GraphEdgeBuilder endTimestamp(LocalDateTime endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GraphEdgeBuilder duration(GraphEdgeDuration duration) {
            this.duration = duration;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GraphEdge build() {
            return new GraphEdge(this.sourceIndex, this.targetIndex, this.relatedIndexes, this.type, this.label, this.description, this.sampleSize, this.startTimestamp, this.endTimestamp, this.duration);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "GraphEdge.GraphEdgeBuilder(sourceIndex=" + this.sourceIndex + ", targetIndex=" + this.targetIndex + ", relatedIndexes=" + this.relatedIndexes + ", type=" + this.type + ", label=" + this.label + ", description=" + this.description + ", sampleSize=" + this.sampleSize + ", startTimestamp=" + this.startTimestamp + ", endTimestamp=" + this.endTimestamp + ", duration=" + this.duration + ")";
        }
    }
}

