/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import tech.kronicle.sdk.models.Component;
import tech.kronicle.sdk.models.Link;
import tech.kronicle.sdk.models.ObjectWithId;
import tech.kronicle.sdk.models.ObjectWithReference;
import tech.kronicle.sdk.models.Team;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=AreaBuilder.class)
public final class Area
implements ObjectWithId,
ObjectWithReference {
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*")
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*") String id;
    @NotBlank
    private final String name;
    private final List<@NotBlank @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*") String> tags;
    private final String description;
    private final String notes;
    private final List<@Valid Link> links;
    private final List<@Valid Team> teams;
    private final List<@Valid Component> components;

    public Area(String id, String name, List<String> tags, String description, String notes, List<Link> links, List<Team> teams, List<Component> components) {
        this.id = id;
        this.name = name;
        this.tags = ListUtils.createUnmodifiableList(tags);
        this.description = description;
        this.notes = notes;
        this.links = ListUtils.createUnmodifiableList(links);
        this.teams = ListUtils.createUnmodifiableList(teams);
        this.components = ListUtils.createUnmodifiableList(components);
    }

    @Override
    public String reference() {
        return this.id;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static AreaBuilder builder() {
        return new AreaBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AreaBuilder toBuilder() {
        return new AreaBuilder().id(this.id).name(this.name).tags(this.tags).description(this.description).notes(this.notes).links(this.links).teams(this.teams).components(this.components);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@NotBlank @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*") String> getTags() {
        return this.tags;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDescription() {
        return this.description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getNotes() {
        return this.notes;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid Link> getLinks() {
        return this.links;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid Team> getTeams() {
        return this.teams;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid Component> getComponents() {
        return this.components;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Area)) {
            return false;
        }
        Area other = (Area)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$notes = this.getNotes();
        String other$notes = other.getNotes();
        if (this$notes == null ? other$notes != null : !this$notes.equals(other$notes)) {
            return false;
        }
        List<Link> this$links = this.getLinks();
        List<Link> other$links = other.getLinks();
        if (this$links == null ? other$links != null : !((Object)this$links).equals(other$links)) {
            return false;
        }
        List<Team> this$teams = this.getTeams();
        List<Team> other$teams = other.getTeams();
        if (this$teams == null ? other$teams != null : !((Object)this$teams).equals(other$teams)) {
            return false;
        }
        List<Component> this$components = this.getComponents();
        List<Component> other$components = other.getComponents();
        return !(this$components == null ? other$components != null : !((Object)this$components).equals(other$components));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $notes = this.getNotes();
        result = result * 59 + ($notes == null ? 43 : $notes.hashCode());
        List<Link> $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        List<Team> $teams = this.getTeams();
        result = result * 59 + ($teams == null ? 43 : ((Object)$teams).hashCode());
        List<Component> $components = this.getComponents();
        result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "Area(id=" + this.getId() + ", name=" + this.getName() + ", tags=" + this.getTags() + ", description=" + this.getDescription() + ", notes=" + this.getNotes() + ", links=" + this.getLinks() + ", teams=" + this.getTeams() + ", components=" + this.getComponents() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Area withId(String id) {
        return this.id == id ? this : new Area(id, this.name, this.tags, this.description, this.notes, this.links, this.teams, this.components);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Area withName(String name) {
        return this.name == name ? this : new Area(this.id, name, this.tags, this.description, this.notes, this.links, this.teams, this.components);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Area withTags(List<@NotBlank @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*") String> tags) {
        return this.tags == tags ? this : new Area(this.id, this.name, tags, this.description, this.notes, this.links, this.teams, this.components);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Area withDescription(String description) {
        return this.description == description ? this : new Area(this.id, this.name, this.tags, description, this.notes, this.links, this.teams, this.components);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Area withNotes(String notes) {
        return this.notes == notes ? this : new Area(this.id, this.name, this.tags, this.description, notes, this.links, this.teams, this.components);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Area withLinks(List<@Valid Link> links) {
        return this.links == links ? this : new Area(this.id, this.name, this.tags, this.description, this.notes, links, this.teams, this.components);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Area withTeams(List<@Valid Team> teams) {
        return this.teams == teams ? this : new Area(this.id, this.name, this.tags, this.description, this.notes, this.links, teams, this.components);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Area withComponents(List<@Valid Component> components) {
        return this.components == components ? this : new Area(this.id, this.name, this.tags, this.description, this.notes, this.links, this.teams, components);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class AreaBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String id;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String name;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@NotBlank @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*") String> tags;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String description;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String notes;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid Link> links;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid Team> teams;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid Component> components;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        AreaBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public AreaBuilder id(String id) {
            this.id = id;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public AreaBuilder name(String name) {
            this.name = name;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public AreaBuilder tags(List<@NotBlank @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*") String> tags) {
            this.tags = tags;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public AreaBuilder description(String description) {
            this.description = description;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public AreaBuilder notes(String notes) {
            this.notes = notes;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public AreaBuilder links(List<@Valid Link> links) {
            this.links = links;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public AreaBuilder teams(List<@Valid Team> teams) {
            this.teams = teams;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public AreaBuilder components(List<@Valid Component> components) {
            this.components = components;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Area build() {
            return new Area(this.id, this.name, this.tags, this.description, this.notes, this.links, this.teams, this.components);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Area.AreaBuilder(id=" + this.id + ", name=" + this.name + ", tags=" + this.tags + ", description=" + this.description + ", notes=" + this.notes + ", links=" + this.links + ", teams=" + this.teams + ", components=" + this.components + ")";
        }
    }
}

