/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import tech.kronicle.sdk.models.ComponentState;
import tech.kronicle.sdk.models.todos.ToDo;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=ToDosStateBuilder.class)
public final class ToDosState
implements ComponentState {
    public static final String TYPE = "to-dos";
    private final String type = "to-dos";
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*")
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String pluginId;
    private final String id;
    @NotNull
    @Valid
    private final List<ToDo> toDos;

    public ToDosState(String pluginId, List<ToDo> toDos) {
        this.id = null;
        this.pluginId = pluginId;
        this.toDos = ListUtils.createUnmodifiableList(toDos);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static ToDosStateBuilder builder() {
        return new ToDosStateBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ToDosStateBuilder toBuilder() {
        return new ToDosStateBuilder().pluginId(this.pluginId).toDos(this.toDos);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getType() {
        return this.type;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @NotNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<ToDo> getToDos() {
        return this.toDos;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ToDosState)) {
            return false;
        }
        ToDosState other = (ToDosState)o;
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<ToDo> this$toDos = this.getToDos();
        List<ToDo> other$toDos = other.getToDos();
        return !(this$toDos == null ? other$toDos != null : !((Object)this$toDos).equals(other$toDos));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<ToDo> $toDos = this.getToDos();
        result = result * 59 + ($toDos == null ? 43 : ((Object)$toDos).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ToDosState(type=" + this.getType() + ", pluginId=" + this.getPluginId() + ", id=" + this.getId() + ", toDos=" + this.getToDos() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ToDosState withPluginId(String pluginId) {
        return this.pluginId == pluginId ? this : new ToDosState(pluginId, this.toDos);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ToDosState withToDos(@NotNull List<ToDo> toDos) {
        return this.toDos == toDos ? this : new ToDosState(this.pluginId, toDos);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class ToDosStateBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String pluginId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<ToDo> toDos;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        ToDosStateBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ToDosStateBuilder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ToDosStateBuilder toDos(@NotNull List<ToDo> toDos) {
            this.toDos = toDos;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ToDosState build() {
            return new ToDosState(this.pluginId, this.toDos);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ToDosState.ToDosStateBuilder(pluginId=" + this.pluginId + ", toDos=" + this.toDos + ")";
        }
    }
}

