/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import tech.kronicle.sdk.models.ComponentState;
import tech.kronicle.sdk.models.sonarqube.SonarQubeProject;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=SonarQubeProjectsStateBuilder.class)
public final class SonarQubeProjectsState
implements ComponentState {
    public static final String TYPE = "sonarqube-projects";
    private final String type = "sonarqube-projects";
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*")
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String pluginId;
    private final String id;
    private final @NotNull List<@Valid SonarQubeProject> sonarQubeProjects;

    public SonarQubeProjectsState(String pluginId, List<@Valid SonarQubeProject> sonarQubeProjects) {
        this.id = null;
        this.pluginId = pluginId;
        this.sonarQubeProjects = ListUtils.createUnmodifiableList(sonarQubeProjects);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static SonarQubeProjectsStateBuilder builder() {
        return new SonarQubeProjectsStateBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SonarQubeProjectsStateBuilder toBuilder() {
        return new SonarQubeProjectsStateBuilder().pluginId(this.pluginId).sonarQubeProjects(this.sonarQubeProjects);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getType() {
        return this.type;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @NotNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public @NotNull List<@Valid SonarQubeProject> getSonarQubeProjects() {
        return this.sonarQubeProjects;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SonarQubeProjectsState)) {
            return false;
        }
        SonarQubeProjectsState other = (SonarQubeProjectsState)o;
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<SonarQubeProject> this$sonarQubeProjects = this.getSonarQubeProjects();
        List<SonarQubeProject> other$sonarQubeProjects = other.getSonarQubeProjects();
        return !(this$sonarQubeProjects == null ? other$sonarQubeProjects != null : !((Object)this$sonarQubeProjects).equals(other$sonarQubeProjects));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<SonarQubeProject> $sonarQubeProjects = this.getSonarQubeProjects();
        result = result * 59 + ($sonarQubeProjects == null ? 43 : ((Object)$sonarQubeProjects).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "SonarQubeProjectsState(type=" + this.getType() + ", pluginId=" + this.getPluginId() + ", id=" + this.getId() + ", sonarQubeProjects=" + this.getSonarQubeProjects() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SonarQubeProjectsState withPluginId(String pluginId) {
        return this.pluginId == pluginId ? this : new SonarQubeProjectsState(pluginId, this.sonarQubeProjects);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SonarQubeProjectsState withSonarQubeProjects(@NotNull List<@Valid SonarQubeProject> sonarQubeProjects) {
        return this.sonarQubeProjects == sonarQubeProjects ? this : new SonarQubeProjectsState(this.pluginId, sonarQubeProjects);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class SonarQubeProjectsStateBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String pluginId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid SonarQubeProject> sonarQubeProjects;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SonarQubeProjectsStateBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SonarQubeProjectsStateBuilder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SonarQubeProjectsStateBuilder sonarQubeProjects(@NotNull List<@Valid SonarQubeProject> sonarQubeProjects) {
            this.sonarQubeProjects = sonarQubeProjects;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SonarQubeProjectsState build() {
            return new SonarQubeProjectsState(this.pluginId, this.sonarQubeProjects);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "SonarQubeProjectsState.SonarQubeProjectsStateBuilder(pluginId=" + this.pluginId + ", sonarQubeProjects=" + this.sonarQubeProjects + ")";
        }
    }
}

