/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models.openapi;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import tech.kronicle.sdk.models.ComponentState;
import tech.kronicle.sdk.models.openapi.OpenApiSpec;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=OpenApiSpecsStateBuilder.class)
public final class OpenApiSpecsState
implements ComponentState {
    public static final String TYPE = "openapi-specs";
    private final String type = "openapi-specs";
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*")
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String pluginId;
    private final @NotNull List<@Valid OpenApiSpec> openApiSpecs;

    public OpenApiSpecsState(String pluginId, List<OpenApiSpec> openApiSpecs) {
        this.pluginId = pluginId;
        this.openApiSpecs = ListUtils.createUnmodifiableList(openApiSpecs);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static OpenApiSpecsStateBuilder builder() {
        return new OpenApiSpecsStateBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OpenApiSpecsStateBuilder toBuilder() {
        return new OpenApiSpecsStateBuilder().pluginId(this.pluginId).openApiSpecs(this.openApiSpecs);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getType() {
        return this.type;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPluginId() {
        return this.pluginId;
    }

    @NotNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public @NotNull List<@Valid OpenApiSpec> getOpenApiSpecs() {
        return this.openApiSpecs;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenApiSpecsState)) {
            return false;
        }
        OpenApiSpecsState other = (OpenApiSpecsState)o;
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        List<OpenApiSpec> this$openApiSpecs = this.getOpenApiSpecs();
        List<OpenApiSpec> other$openApiSpecs = other.getOpenApiSpecs();
        return !(this$openApiSpecs == null ? other$openApiSpecs != null : !((Object)this$openApiSpecs).equals(other$openApiSpecs));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        List<OpenApiSpec> $openApiSpecs = this.getOpenApiSpecs();
        result = result * 59 + ($openApiSpecs == null ? 43 : ((Object)$openApiSpecs).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "OpenApiSpecsState(type=" + this.getType() + ", pluginId=" + this.getPluginId() + ", openApiSpecs=" + this.getOpenApiSpecs() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OpenApiSpecsState withPluginId(String pluginId) {
        return this.pluginId == pluginId ? this : new OpenApiSpecsState(pluginId, this.openApiSpecs);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OpenApiSpecsState withOpenApiSpecs(@NotNull List<@Valid OpenApiSpec> openApiSpecs) {
        return this.openApiSpecs == openApiSpecs ? this : new OpenApiSpecsState(this.pluginId, openApiSpecs);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class OpenApiSpecsStateBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String pluginId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid OpenApiSpec> openApiSpecs;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        OpenApiSpecsStateBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public OpenApiSpecsStateBuilder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public OpenApiSpecsStateBuilder openApiSpecs(@NotNull List<@Valid OpenApiSpec> openApiSpecs) {
            this.openApiSpecs = openApiSpecs;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public OpenApiSpecsState build() {
            return new OpenApiSpecsState(this.pluginId, this.openApiSpecs);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "OpenApiSpecsState.OpenApiSpecsStateBuilder(pluginId=" + this.pluginId + ", openApiSpecs=" + this.openApiSpecs + ")";
        }
    }
}

