/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDateTime;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import tech.kronicle.sdk.models.LogLevelSummary;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=LogSummaryBuilder.class)
public final class LogSummary {
    @NotEmpty
    private final String name;
    @NotNull
    private final LocalDateTime startTimestamp;
    @NotNull
    private final LocalDateTime endTimestamp;
    private final List<@NotNull @Valid LogLevelSummary> levels;

    public LogSummary(String name, LocalDateTime startTimestamp, LocalDateTime endTimestamp, List<LogLevelSummary> levels) {
        this.name = name;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.levels = ListUtils.createUnmodifiableList(levels);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static LogSummaryBuilder builder() {
        return new LogSummaryBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LogSummaryBuilder toBuilder() {
        return new LogSummaryBuilder().name(this.name).startTimestamp(this.startTimestamp).endTimestamp(this.endTimestamp).levels(this.levels);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @NotNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDateTime getStartTimestamp() {
        return this.startTimestamp;
    }

    @NotNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDateTime getEndTimestamp() {
        return this.endTimestamp;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@NotNull @Valid LogLevelSummary> getLevels() {
        return this.levels;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogSummary)) {
            return false;
        }
        LogSummary other = (LogSummary)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        LocalDateTime this$startTimestamp = this.getStartTimestamp();
        LocalDateTime other$startTimestamp = other.getStartTimestamp();
        if (this$startTimestamp == null ? other$startTimestamp != null : !((Object)this$startTimestamp).equals(other$startTimestamp)) {
            return false;
        }
        LocalDateTime this$endTimestamp = this.getEndTimestamp();
        LocalDateTime other$endTimestamp = other.getEndTimestamp();
        if (this$endTimestamp == null ? other$endTimestamp != null : !((Object)this$endTimestamp).equals(other$endTimestamp)) {
            return false;
        }
        List<LogLevelSummary> this$levels = this.getLevels();
        List<LogLevelSummary> other$levels = other.getLevels();
        return !(this$levels == null ? other$levels != null : !((Object)this$levels).equals(other$levels));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        LocalDateTime $startTimestamp = this.getStartTimestamp();
        result = result * 59 + ($startTimestamp == null ? 43 : ((Object)$startTimestamp).hashCode());
        LocalDateTime $endTimestamp = this.getEndTimestamp();
        result = result * 59 + ($endTimestamp == null ? 43 : ((Object)$endTimestamp).hashCode());
        List<LogLevelSummary> $levels = this.getLevels();
        result = result * 59 + ($levels == null ? 43 : ((Object)$levels).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "LogSummary(name=" + this.getName() + ", startTimestamp=" + this.getStartTimestamp() + ", endTimestamp=" + this.getEndTimestamp() + ", levels=" + this.getLevels() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LogSummary withName(String name) {
        return this.name == name ? this : new LogSummary(name, this.startTimestamp, this.endTimestamp, this.levels);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LogSummary withStartTimestamp(@NotNull LocalDateTime startTimestamp) {
        return this.startTimestamp == startTimestamp ? this : new LogSummary(this.name, startTimestamp, this.endTimestamp, this.levels);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LogSummary withEndTimestamp(@NotNull LocalDateTime endTimestamp) {
        return this.endTimestamp == endTimestamp ? this : new LogSummary(this.name, this.startTimestamp, endTimestamp, this.levels);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LogSummary withLevels(List<@NotNull @Valid LogLevelSummary> levels) {
        return this.levels == levels ? this : new LogSummary(this.name, this.startTimestamp, this.endTimestamp, levels);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class LogSummaryBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String name;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDateTime startTimestamp;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDateTime endTimestamp;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@NotNull @Valid LogLevelSummary> levels;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        LogSummaryBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LogSummaryBuilder name(String name) {
            this.name = name;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LogSummaryBuilder startTimestamp(@NotNull LocalDateTime startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LogSummaryBuilder endTimestamp(@NotNull LocalDateTime endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LogSummaryBuilder levels(List<@NotNull @Valid LogLevelSummary> levels) {
            this.levels = levels;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LogSummary build() {
            return new LogSummary(this.name, this.startTimestamp, this.endTimestamp, this.levels);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "LogSummary.LogSummaryBuilder(name=" + this.name + ", startTimestamp=" + this.startTimestamp + ", endTimestamp=" + this.endTimestamp + ", levels=" + this.levels + ")";
        }
    }
}

