/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDateTime;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import tech.kronicle.sdk.models.ComponentEnvironmentState;
import tech.kronicle.sdk.models.ComponentStateCheckStatus;
import tech.kronicle.sdk.models.Link;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=CheckStateBuilder.class)
public final class CheckState
implements ComponentEnvironmentState {
    public static final String TYPE = "check";
    private final String type = "check";
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*")
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String pluginId;
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*")
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String environmentId;
    @NotEmpty
    private final String name;
    private final String description;
    private final String avatarUrl;
    @NotNull
    private final ComponentStateCheckStatus status;
    @NotEmpty
    private final String statusMessage;
    private final List<@Valid Link> links;
    @NotNull
    private final LocalDateTime updateTimestamp;

    public CheckState(String pluginId, String environmentId, String name, String description, String avatarUrl, ComponentStateCheckStatus status, String statusMessage, List<Link> links, LocalDateTime updateTimestamp) {
        this.pluginId = pluginId;
        this.environmentId = environmentId;
        this.name = name;
        this.description = description;
        this.avatarUrl = avatarUrl;
        this.status = status;
        this.statusMessage = statusMessage;
        this.links = ListUtils.createUnmodifiableList(links);
        this.updateTimestamp = updateTimestamp;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static CheckStateBuilder builder() {
        return new CheckStateBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CheckStateBuilder toBuilder() {
        return new CheckStateBuilder().pluginId(this.pluginId).environmentId(this.environmentId).name(this.name).description(this.description).avatarUrl(this.avatarUrl).status(this.status).statusMessage(this.statusMessage).links(this.links).updateTimestamp(this.updateTimestamp);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getType() {
        return this.type;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDescription() {
        return this.description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    @NotNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ComponentStateCheckStatus getStatus() {
        return this.status;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getStatusMessage() {
        return this.statusMessage;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid Link> getLinks() {
        return this.links;
    }

    @NotNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDateTime getUpdateTimestamp() {
        return this.updateTimestamp;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CheckState)) {
            return false;
        }
        CheckState other = (CheckState)o;
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        String this$environmentId = this.getEnvironmentId();
        String other$environmentId = other.getEnvironmentId();
        if (this$environmentId == null ? other$environmentId != null : !this$environmentId.equals(other$environmentId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$avatarUrl = this.getAvatarUrl();
        String other$avatarUrl = other.getAvatarUrl();
        if (this$avatarUrl == null ? other$avatarUrl != null : !this$avatarUrl.equals(other$avatarUrl)) {
            return false;
        }
        ComponentStateCheckStatus this$status = this.getStatus();
        ComponentStateCheckStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$statusMessage = this.getStatusMessage();
        String other$statusMessage = other.getStatusMessage();
        if (this$statusMessage == null ? other$statusMessage != null : !this$statusMessage.equals(other$statusMessage)) {
            return false;
        }
        List<Link> this$links = this.getLinks();
        List<Link> other$links = other.getLinks();
        if (this$links == null ? other$links != null : !((Object)this$links).equals(other$links)) {
            return false;
        }
        LocalDateTime this$updateTimestamp = this.getUpdateTimestamp();
        LocalDateTime other$updateTimestamp = other.getUpdateTimestamp();
        return !(this$updateTimestamp == null ? other$updateTimestamp != null : !((Object)this$updateTimestamp).equals(other$updateTimestamp));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        String $environmentId = this.getEnvironmentId();
        result = result * 59 + ($environmentId == null ? 43 : $environmentId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $avatarUrl = this.getAvatarUrl();
        result = result * 59 + ($avatarUrl == null ? 43 : $avatarUrl.hashCode());
        ComponentStateCheckStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $statusMessage = this.getStatusMessage();
        result = result * 59 + ($statusMessage == null ? 43 : $statusMessage.hashCode());
        List<Link> $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        LocalDateTime $updateTimestamp = this.getUpdateTimestamp();
        result = result * 59 + ($updateTimestamp == null ? 43 : ((Object)$updateTimestamp).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "CheckState(type=" + this.getType() + ", pluginId=" + this.getPluginId() + ", environmentId=" + this.getEnvironmentId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", avatarUrl=" + this.getAvatarUrl() + ", status=" + this.getStatus() + ", statusMessage=" + this.getStatusMessage() + ", links=" + this.getLinks() + ", updateTimestamp=" + this.getUpdateTimestamp() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CheckState withPluginId(String pluginId) {
        return this.pluginId == pluginId ? this : new CheckState(pluginId, this.environmentId, this.name, this.description, this.avatarUrl, this.status, this.statusMessage, this.links, this.updateTimestamp);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CheckState withEnvironmentId(String environmentId) {
        return this.environmentId == environmentId ? this : new CheckState(this.pluginId, environmentId, this.name, this.description, this.avatarUrl, this.status, this.statusMessage, this.links, this.updateTimestamp);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CheckState withName(String name) {
        return this.name == name ? this : new CheckState(this.pluginId, this.environmentId, name, this.description, this.avatarUrl, this.status, this.statusMessage, this.links, this.updateTimestamp);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CheckState withDescription(String description) {
        return this.description == description ? this : new CheckState(this.pluginId, this.environmentId, this.name, description, this.avatarUrl, this.status, this.statusMessage, this.links, this.updateTimestamp);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CheckState withAvatarUrl(String avatarUrl) {
        return this.avatarUrl == avatarUrl ? this : new CheckState(this.pluginId, this.environmentId, this.name, this.description, avatarUrl, this.status, this.statusMessage, this.links, this.updateTimestamp);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CheckState withStatus(@NotNull ComponentStateCheckStatus status) {
        return this.status == status ? this : new CheckState(this.pluginId, this.environmentId, this.name, this.description, this.avatarUrl, status, this.statusMessage, this.links, this.updateTimestamp);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CheckState withStatusMessage(String statusMessage) {
        return this.statusMessage == statusMessage ? this : new CheckState(this.pluginId, this.environmentId, this.name, this.description, this.avatarUrl, this.status, statusMessage, this.links, this.updateTimestamp);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CheckState withLinks(List<@Valid Link> links) {
        return this.links == links ? this : new CheckState(this.pluginId, this.environmentId, this.name, this.description, this.avatarUrl, this.status, this.statusMessage, links, this.updateTimestamp);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CheckState withUpdateTimestamp(@NotNull LocalDateTime updateTimestamp) {
        return this.updateTimestamp == updateTimestamp ? this : new CheckState(this.pluginId, this.environmentId, this.name, this.description, this.avatarUrl, this.status, this.statusMessage, this.links, updateTimestamp);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class CheckStateBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String pluginId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String environmentId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String name;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String description;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String avatarUrl;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ComponentStateCheckStatus status;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String statusMessage;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid Link> links;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDateTime updateTimestamp;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        CheckStateBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CheckStateBuilder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CheckStateBuilder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CheckStateBuilder name(String name) {
            this.name = name;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CheckStateBuilder description(String description) {
            this.description = description;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CheckStateBuilder avatarUrl(String avatarUrl) {
            this.avatarUrl = avatarUrl;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CheckStateBuilder status(@NotNull ComponentStateCheckStatus status) {
            this.status = status;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CheckStateBuilder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CheckStateBuilder links(List<@Valid Link> links) {
            this.links = links;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CheckStateBuilder updateTimestamp(@NotNull LocalDateTime updateTimestamp) {
            this.updateTimestamp = updateTimestamp;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CheckState build() {
            return new CheckState(this.pluginId, this.environmentId, this.name, this.description, this.avatarUrl, this.status, this.statusMessage, this.links, this.updateTimestamp);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "CheckState.CheckStateBuilder(pluginId=" + this.pluginId + ", environmentId=" + this.environmentId + ", name=" + this.name + ", description=" + this.description + ", avatarUrl=" + this.avatarUrl + ", status=" + this.status + ", statusMessage=" + this.statusMessage + ", links=" + this.links + ", updateTimestamp=" + this.updateTimestamp + ")";
        }
    }
}

