/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models.sonarqube;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDateTime;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import tech.kronicle.sdk.models.sonarqube.SonarQubeMeasure;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=SonarQubeProjectBuilder.class)
public final class SonarQubeProject {
    @NotBlank
    private final String key;
    @NotBlank
    private final String name;
    @NotBlank
    private final String url;
    private final LocalDateTime lastCommitTimestamp;
    private final List<@Valid SonarQubeMeasure> measures;

    public SonarQubeProject(String key, String name, String url, LocalDateTime lastCommitTimestamp, List<SonarQubeMeasure> measures) {
        this.key = key;
        this.name = name;
        this.url = url;
        this.lastCommitTimestamp = lastCommitTimestamp;
        this.measures = ListUtils.createUnmodifiableList(measures);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static SonarQubeProjectBuilder builder() {
        return new SonarQubeProjectBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SonarQubeProjectBuilder toBuilder() {
        return new SonarQubeProjectBuilder().key(this.key).name(this.name).url(this.url).lastCommitTimestamp(this.lastCommitTimestamp).measures(this.measures);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getKey() {
        return this.key;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getUrl() {
        return this.url;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDateTime getLastCommitTimestamp() {
        return this.lastCommitTimestamp;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid SonarQubeMeasure> getMeasures() {
        return this.measures;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SonarQubeProject)) {
            return false;
        }
        SonarQubeProject other = (SonarQubeProject)o;
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        LocalDateTime this$lastCommitTimestamp = this.getLastCommitTimestamp();
        LocalDateTime other$lastCommitTimestamp = other.getLastCommitTimestamp();
        if (this$lastCommitTimestamp == null ? other$lastCommitTimestamp != null : !((Object)this$lastCommitTimestamp).equals(other$lastCommitTimestamp)) {
            return false;
        }
        List<SonarQubeMeasure> this$measures = this.getMeasures();
        List<SonarQubeMeasure> other$measures = other.getMeasures();
        return !(this$measures == null ? other$measures != null : !((Object)this$measures).equals(other$measures));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        LocalDateTime $lastCommitTimestamp = this.getLastCommitTimestamp();
        result = result * 59 + ($lastCommitTimestamp == null ? 43 : ((Object)$lastCommitTimestamp).hashCode());
        List<SonarQubeMeasure> $measures = this.getMeasures();
        result = result * 59 + ($measures == null ? 43 : ((Object)$measures).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "SonarQubeProject(key=" + this.getKey() + ", name=" + this.getName() + ", url=" + this.getUrl() + ", lastCommitTimestamp=" + this.getLastCommitTimestamp() + ", measures=" + this.getMeasures() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SonarQubeProject withKey(String key) {
        return this.key == key ? this : new SonarQubeProject(key, this.name, this.url, this.lastCommitTimestamp, this.measures);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SonarQubeProject withName(String name) {
        return this.name == name ? this : new SonarQubeProject(this.key, name, this.url, this.lastCommitTimestamp, this.measures);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SonarQubeProject withUrl(String url) {
        return this.url == url ? this : new SonarQubeProject(this.key, this.name, url, this.lastCommitTimestamp, this.measures);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SonarQubeProject withLastCommitTimestamp(LocalDateTime lastCommitTimestamp) {
        return this.lastCommitTimestamp == lastCommitTimestamp ? this : new SonarQubeProject(this.key, this.name, this.url, lastCommitTimestamp, this.measures);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SonarQubeProject withMeasures(List<@Valid SonarQubeMeasure> measures) {
        return this.measures == measures ? this : new SonarQubeProject(this.key, this.name, this.url, this.lastCommitTimestamp, measures);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class SonarQubeProjectBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String key;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String name;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String url;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDateTime lastCommitTimestamp;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid SonarQubeMeasure> measures;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SonarQubeProjectBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SonarQubeProjectBuilder key(String key) {
            this.key = key;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SonarQubeProjectBuilder name(String name) {
            this.name = name;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SonarQubeProjectBuilder url(String url) {
            this.url = url;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SonarQubeProjectBuilder lastCommitTimestamp(LocalDateTime lastCommitTimestamp) {
            this.lastCommitTimestamp = lastCommitTimestamp;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SonarQubeProjectBuilder measures(List<@Valid SonarQubeMeasure> measures) {
            this.measures = measures;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SonarQubeProject build() {
            return new SonarQubeProject(this.key, this.name, this.url, this.lastCommitTimestamp, this.measures);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "SonarQubeProject.SonarQubeProjectBuilder(key=" + this.key + ", name=" + this.name + ", url=" + this.url + ", lastCommitTimestamp=" + this.lastCommitTimestamp + ", measures=" + this.measures + ")";
        }
    }
}

